/**
 * i-doit Floorplan JS component for rotating objects.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
function floorplanDragRotate(floorplan) {
    var tmp;
    
    return d3.drag()
        .on('start', function (d) {
            var $objectNode = floorplan.vis.select('.level-' + floorplan.uuid + '[data-id="' + d.objId + '"]'),
                transform   = d3.zoomTransform(floorplan.svg.node());
            
            // Hide all scaling points
            $objectNode.selectAll('.scale-circle,.toggle-floorplan').classed('hide', true);
            
            var $rotateContainer = $objectNode
                .append('g')
                .attr('transform', function (d) {
                    return 'rotate(-' + d.angle + ')scale(' + (1 / transform.k) + ')'
                });
            
            $rotateContainer.append('rect')
                .attr('class', 'white-box')
                .attr('width', 35)
                .attr('height', 20)
                .attr('rx', 2)
                .attr('ry', 2)
                .attr('transform', 'translate(-20, -14)');
            
            $rotateContainer.append('text')
                .attr('class', 'drag-rotate-text')
                .attr('transform', 'translate(0)')
                .style('text-anchor', 'middle')
                .html(function (d) { return Math.floor(d.angle) + '&deg;'; });
            
            tmp = {
                $object: $objectNode,
                $rotateContainer: $rotateContainer,
                scale: transform.k
            };
            
            d.angleRad = FloorplanHelper.fromDegrees(d.angle);
        })
        .on('drag', function (d) {
            var exy = [d3.event.x, (d3.event.y - (d.height / 2 + 35 * tmp.scale))],
                dxy = [d.x, d.y];
            
            d.angleRad = (Math.PI / 2) + d.angleRad + FloorplanHelper.angleBetweenPoints(dxy, exy);
            d.angle = FloorplanHelper.toDegrees(d.angleRad);
            
            floorplan.updateObjectPositions(d.objId);

            tmp.$rotateContainer
                .attr('transform', function (d) { return 'rotate(-' + d.angle + ')scale(' + (1 / tmp.scale) + ')'; });
            tmp.$rotateContainer.select('.drag-rotate-text')
                .html(function (d) { return Math.floor(d.angle) + '&deg;' });
        })
        .on('end', function (d) {
            delete d.angleRad;
            
            tmp.$object.selectAll('.scale-circle,.toggle-floorplan').classed('hide', false);
            tmp.$rotateContainer.remove();
            
            floorplan.updateObjectPositions(d.objId);
            
            tmp = null;
        });
}
