<?php

namespace idoit\Module\Floorplan\Controller;

use idoit\Module\Floorplan\Model\Profile as ProfileModel;
use isys_component_dao_user_settings as DaoUserSettings;
use isys_format_json as JSON;
use isys_register as Register;
use isys_usersettings as UserSettings;

/**
 * i-doit cmdb controller
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Profile extends Ajax
{
    /**
     * This method saves the floorplan profiles and returns the "current set".
     *
     * @param Register $request
     */
    public function save(Register $request)
    {
        try {
            $language = $this->getDi()->get('language');
            $profileModel = new ProfileModel($this->getDi()->get('database'));

            $profileData = (array)JSON::decode($request->get('POST')->get('profiles'));
            $deletedProfiles = (array)JSON::decode($request->get('POST')->get('deletedProfiles'));

            foreach ($deletedProfiles as $profileId) {
                // We only delete profiles with "real" ids.
                if ($profileId > 0) {
                    $profileModel->deleteProfile($profileId);
                }
            }

            foreach ($profileData as $profile) {
                $id = ($profile['id'] > 0 ? $profile['id'] : null);

                $profileModel->saveProfile($id, $profile);
            }

            $profiles = [];
            $profileResult = $profileModel->getProfiles();

            while ($profileRow = $profileResult->get_row()) {
                $profileRow['id'] = (int)$profileRow['id'];
                $profileRow['title'] = $language->get($profileRow['title']);
                $profileRow['config'] = JSON::decode($profileRow['config']);

                unset($profileRow['status'], $profileRow['const']);

                $profiles[] = $profileRow;
            }

            $this->response['data'] = $profiles;
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * This method will set the given profile ID as the users default profile.
     *
     * @param Register $request
     */
    public function makeDefault(Register $request)
    {
        try {
            UserSettings::set('floorplan.default-profile', (int)$request->get('POST')->get('profileId'));

            $this->response['data'] = true;
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * This method will set the given profile ID as the users default profile.
     *
     * @param Register $request
     */
    public function makeUserDefault(Register $request)
    {
        try {
            $profileId = (int)$request->get('POST')->get('profileId');
            $users = (array)JSON::decode($request->get('POST')->get('users'));

            $settingsDao = new DaoUserSettings($this->getDi()->get('database'));

            foreach ($users as $userId) {
                $settingsDao->set('floorplan.default-profile', $profileId, $userId);

                UserSettings::regenerate($userId);
            }

            $this->response['data'] = true;
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * This method will set the given profile ID as the users default profile.
     *
     * @param Register $request
     */
    public function makeGlobalDefault(Register $request)
    {
        try {
            \isys_tenantsettings::set('floorplan.default-profile', (int)$request->get('POST')->get('profileId'));

            $this->response['data'] = true;
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }
}
