<?php

namespace idoit\Module\Floorplan\Model;

use idoit\Model\Dao\Base;
use isys_format_json as JSON;

/**
 * i-doit Floorplan Model
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Profile extends Base
{
    /**
     * Fields of "isys_floorplan_profile".
     */
    const FIELDS = [
        'isys_floorplan_profile__id'     => 'id',
        'isys_floorplan_profile__title'  => 'title',
        'isys_floorplan_profile__const'  => 'const',
        'isys_floorplan_profile__config' => 'config',
        'isys_floorplan_profile__status' => 'status',
    ];

    /**
     * @param  integer $id
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getProfile($id)
    {
        $select = $this->selectImplode(self::FIELDS);

        $sql = 'SELECT ' . $select . ' 
            FROM isys_floorplan_profile 
            WHERE isys_floorplan_profile__status = ' . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . '
            AND isys_floorplan_profile__id = ' . $this->convert_sql_id($id) . ';';

        return $this->retrieve($sql);
    }

    /**
     * Method for retrieving all profiles.
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getProfiles()
    {
        $select = $this->selectImplode(self::FIELDS);

        $sql = 'SELECT ' . $select . ' 
            FROM isys_floorplan_profile 
            WHERE isys_floorplan_profile__status = ' . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';

        return $this->retrieve($sql);
    }

    /**
     * @param  integer $id
     * @param  array   $data
     *
     * @return boolean
     * @throws \isys_exception_dao
     */
    public function saveProfile($id, array $data)
    {
        $fields = [];

        foreach ($data as $key => $value) {
            $field = 'isys_floorplan_profile__' . $key;

            if (!self::FIELDS[$field]) {
                continue;
            }

            switch ($key) {
                case 'id':
                    $value = $this->convert_sql_id($value);
                    break;

                default:
                case 'title':
                case 'const':
                    $value = $this->convert_sql_text($value);
                    break;

                case 'config':
                    if (!is_scalar($value)) {
                        $value = JSON::encode($value);
                    }

                    $value = $this->convert_sql_text($value);
                    break;

                case 'status':
                    $value = $this->convert_sql_int($value);
                    break;
            }

            $fields[] = $field . ' = ' . $value;
        }

        if (!count($fields)) {
            return true;
        }

        if ($id === null) {
            $sql = 'INSERT INTO isys_floorplan_profile SET ' . implode(', ', $fields) . ';';
        } else {
            $sql = 'UPDATE isys_floorplan_profile 
                SET ' . implode(', ', $fields) . ' 
                WHERE isys_floorplan_profile__id = ' . $this->convert_sql_id($id) . ';';
        }

        return $this->update($sql) && $this->apply_update();
    }

    /**
     *
     * @param  integer $id
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function deleteProfile($id)
    {
        $sql = 'DELETE FROM isys_floorplan_profile 
            WHERE isys_floorplan_profile__id = ' . $this->convert_sql_id($id) . '
            AND (isys_floorplan_profile__const IS NULL OR isys_floorplan_profile__const = "");';

        return $this->retrieve($sql);
    }
}
