[{isys_group name="left"}]
<!-- We need #tree_content so that clicking on object type groups will still work! -->
<div id="tree_content" style="height:100%;">
	<div id="floorplan-visualization-left">
        <ul id="floorplan-visualization-left-tabs" class="browser-tabs tree-tabs m0">
            <li><a href="#floorplan-visualization-left-objectinformation">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__OBJECT"}]</a></li>
            <li><a href="#floorplan-visualization-left-locationtree">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION"}]</a></li>
        </ul>

        <div id="floorplan-visualization-left-objectinformation">
            <div class="header">
                <h3 class="ml5">
                    <img src="[{isys_module_floorplan::getWwwPath()}]assets/add-on-icon.svg" class="vam mr5" />
                    <span>[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__OBJECT_INFORMATION"}]</span>
                </h3>
            </div>
            <div id="floorplan-visualization-left-content" class="hide opacity-50">
                <table class="mb10 pb0" width="100%">
                    <!-- To be filled by JS -->
                </table>

                <div id="floorplan_object_formfactor_container" class="hide">
                    <label class="display-block mb5">
                        [{isys type="f_text" name="floorplan_object_formfactor__width"}]
                        [{isys type="lang" ident="LC__CMDB__CATG__FORMFACTOR_INSTALLATION_WIDTH"}]
                    </label>
                    <label class="display-block mb5">
                        [{isys type="f_text" name="floorplan_object_formfactor__height"}]
                        [{isys type="lang" ident="LC__CMDB__CATG__FORMFACTOR_INSTALLATION_HEIGHT"}]
                    </label>
                    <label class="display-block mb5">
                        [{isys type="f_text" name="floorplan_object_formfactor__depth"}]
                        [{isys type="lang" ident="LC__CMDB__CATG__FORMFACTOR_INSTALLATION_DEPTH"}]
                    </label>
                    <label class="display-block mb10">
                        [{isys type="f_dialog" name="floorplan_object_formfactor__unit"}]
                    </label>

                    <label class="display-block mb5">
                        <div class="input-group" style="width:50%;">
                            [{isys type="f_text" name="floorplan_object_formfactor__weight"}]

                            [{isys type="f_dialog" name="floorplan_object_formfactor__weight_unit"}]
                        </div>

                        [{isys type="lang" ident="LC__CMDB__CATG__FORMFACTOR_INSTALLATION_WEIGHT"}]
                    </label>

                    <button type="button" class="btn fr mb5" data-action="save-formfactor-data">
                        <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC__NAVIGATION__NAVBAR__SAVE"}]</span>
                    </button>
                </div>

                <div id="floorplan-visualization-left-content-object-information" class="cb">
                    <!-- To be filled by JS -->
                </div>
            </div>

            <div id="floorplan-visualization-left-functions">
                <h3 class="bg-neutral-200 p5 border-top border-bottom">[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__FUNCTIONS"}]</h3>
                <div class="p5 hide">
                    <div class="hide" id="floorplan-visualization-left-functions-orientation-container">
                        [{isys name="floorplan_object_orientation" type="f_dialog" disableInputGroup=true}]
                        [{isys name="floorplan_object_orientation" type="f_label" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__ORIENTATION"}]

                        <br class="cb" />
                    </div>

                    [{isys name="floorplan_polygon_editor_popup" type="f_popup" p_strPopupType="floorplan_polygon_editor" disableInputGroup=true p_plain=true}]

                    <button type="button" class="btn mt5 mr5 hide" data-action="center-object" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__CENTER_ON_OBJECT"}]" data-tooltip="1" disabled="disabled">
                        <img src="[{$dir_images}]axialis/basic/zoom.svg" />
                    </button>

                    <button type="button" class="btn mt5 mr5 hide" data-action="rotate-anticlockwise" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__ROTATE_ANTICLOCKWISE"}]" data-tooltip="1" disabled="disabled">
                        <img src="[{$dir_images}]axialis/cad/modify-rotate.svg" class="flip-horizontally" />
                    </button>

                    <button type="button" class="btn mt5 mr5 hide" data-action="rotate-clockwise" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__ROTATE_CLOCKWISE"}]" data-tooltip="1" disabled="disabled">
                        <img src="[{$dir_images}]axialis/cad/modify-rotate.svg" />
                    </button>

                    <button type="button" class="btn mt5 hide" data-action="unposition-object" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__UNPOSITION"}]" data-tooltip="1" disabled="disabled">
                        <img src="[{$dir_images}]axialis/basic/button-remove.svg" />
                    </button>

                    <button type="button" class="btn btn-block mt5 hide" data-action="edit-object-radius">
                        <img src="[{$dir_images}]axialis/hardware-network/symbol-wireless.svg" class="vam mr5" />
                        <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_RADIUS__BUTTON"}]</span>
                    </button>

                    <button type="button" class="btn btn-block mt5 hide" data-action="inherit-formfactor-data">
                        <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__INHERIT_FORMFACTOR_DATA"}]</span>
                    </button>

                    <button type="button" class="btn btn-block mt5" data-action="toggle-object-type">
                        <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__TOGGLE_OBJ_TYPE"}]</span>
                    </button>

                    <a href="?" class="btn btn-block mt5" target="_blank" data-action="object-link">
                        <img src="[{$dir_images}]axialis/basic/link.svg" /><span>[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__OPEN_OBJECT"}]</span>
                    </a>
                </div>
            </div>

            <div id="floorplan-visualization-left-legend">
                <h3 class="bg-neutral-200 p5 border-top border-bottom">
                    <input type="checkbox" class="fr ml5" style="margin-right:18px;" checked="checked" />
                    <img src="[{$dir_images}]axialis/basic/eye.svg" class="fr" title="[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__FILTER_ALL"}]" />
                    <span>[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__LEGEND"}]</span>
                </h3>
                <ul>
                    [{foreach $objectTypeData as $id => $object_type}]
                        <li data-obj-type-id="[{$id}]">
                            <input type="checkbox" class="fr" checked="checked" value="[{$id}]" />

                            <div>
                                <div class="cmdb-marker mr5" style="background:[{$object_type.color}];"></div>
                                <img src="[{$object_type.icon}]" class="vam mr5" />
                                <label for="obj-type-filter-[{$id}]">[{$object_type.title}]</label>
                            </div>
                        </li>
                    [{/foreach}]
                </ul>
            </div>
        </div>

        <div id="floorplan-visualization-left-locationtree">
            <div class="header">
                <h3 class="ml5">
                    <img src="[{isys_module_floorplan::getWwwPath()}]assets/add-on-icon.svg" class="vam mr5" />
                    <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION"}]</span>
                </h3>
            </div>
            <div id="floorplan-visualization-left-locationtree-options" class="border-bottom">
                <label class="display-block">
                    <input type="radio" name="locationtree-option" value="[{$smarty.const.C__FLOORPLAN__LOCATION_VIEW__LOCATIONS}]" checked="checked" />
                    <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION__MODE_LOCATIONS"}]</span>
                </label>
                <label class="display-block">
                    <input type="radio" name="locationtree-option" value="[{$smarty.const.C__FLOORPLAN__LOCATION_VIEW__FLOORPLANS}]" />
                    <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION__MODE_FLOORPLANS"}]</span>
                </label>
                <label class="display-block">
                    <input type="radio" name="locationtree-option" value="[{$smarty.const.C__FLOORPLAN__LOCATION_VIEW__FLOORPLAN_OBJECTS}]" />
                    <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION__MODE_FLOORPLAN_OBJECTS"}]</span>
                </label>
            </div>
            <div id="floorplan-visualization-left-locationtree-content" class="pl10">
                <!-- To be filled by JS -->
            </div>
        </div>
	</div>
</div>
[{/isys_group}]
