function floorplanLayoutPointDragMove(editor) {
    var tmp = {};
    
    function renderDistance(source, target, $sign) {
        if (!$sign) {
            return;
        }
        
        const distance = window.FloorplanHelper.distanceBetweenPoints([source.x, source.y], [target.x, target.y]);
        const positionX = (source.x + target.x) / 2;
        const positionY = (source.y + target.y) / 2;
    
        $sign
            .classed('hide', false)
            .attr('transform', 'translate(' + positionX + ',' + positionY + ')scale(' + (1 / editor.transform.k) + ')')
        $sign
            .select('rect')
            .attr('transform', 'translate(-40,-14)')
        $sign
            .select('text')
            .text((distance / 100).toFixed(2) + ' m');
    };
    
    return d3.drag()
        .on('start', function (d, i, selection) {
            // Select the draggable.
            editor.selectDraggable.call(editor, d3.select(selection[i]), d, i);
        
            tmp.$previousPoint = selection[i > 0 ? i - 1 : selection.length - 1];
            tmp.$previousSign = editor.$extra
                .append('g')
                .attr('class', 'hide');
            tmp.$previousSign
                .append('rect')
                .attr('class', 'white-box ')
                .attr('width', 80)
                .attr('height', 20)
                .attr('rx', 2)
                .attr('ry', 2);
            tmp.$previousSign
                .append('text')
                .attr('text-anchor', 'middle');
    
            tmp.$nextPoint = selection[i === (selection.length - 1) ? 0 : i + 1];
            tmp.$nextSign = editor.$extra
                .append('g')
                .attr('class', 'hide');
            tmp.$nextSign
                .append('rect')
                .attr('class', 'white-box')
                .attr('width', 80)
                .attr('height', 20)
                .attr('rx', 2)
                .attr('ry', 2);
            tmp.$nextSign
                .append('text')
                .attr('text-anchor', 'middle');
    
            
            editor.$adder.classed('hide', true);
        })
        .on('drag', function (d) {
            d.x = d3.event.x.toFixed(2).toFloat();
            d.y = d3.event.y.toFixed(2).toFloat();
            
            if (editor.options.snapToGrid) {
                d.x = Math.round(d.x / 10) * 10;
                d.y = Math.round(d.y / 10) * 10;
            }
            
            renderDistance(d, d3.select(tmp.$previousPoint).data()[0], tmp.$previousSign);
            renderDistance(d, d3.select(tmp.$nextPoint).data()[0], tmp.$nextSign);
            
            // After the coordinates have been set, refresh the polygon.
            editor.process();
        })
        .on('end', function (d, i) {
            editor.options.$sideBar.fire('point:selected', {
                data:  d,
                index: i
            });
    
            tmp.$previousSign.remove();
            tmp.$nextSign.remove();
            
            delete tmp.$previousSign;
            delete tmp.$previousPoint;
            delete tmp.$nextSign;
            delete tmp.$nextPoint;
            
            editor.process();
        });
}

function floorplanLayoutLayoutDragMove(editor) {
    return d3.drag()
        .on('start', function (d) {
            editor.$adder.classed('hide', true);

            for (const i in d.data) {
                if (!d.data.hasOwnProperty(i)) {
                    continue;
                }
                
                d.data[i].dx = parseInt(d.data[i].x);
                d.data[i].dy = parseInt(d.data[i].y);
            }
        })
        .on('drag', function (d) {
            for (const i in d.data) {
                if (!d.data.hasOwnProperty(i)) {
                    continue;
                }
                
                d.data[i].dx += d3.event.dx;
                d.data[i].dy += d3.event.dy;
                
                if (editor.options.snapToGrid) {
                    d.data[i].x = Math.round(d.data[i].dx / 10) * 10;
                    d.data[i].y = Math.round(d.data[i].dy / 10) * 10;
                } else {
                    d.data[i].x += d3.event.dx.toFixed(2).toFloat();
                    d.data[i].y += d3.event.dy.toFixed(2).toFloat();
                }
            }
            
            editor.process();
        })
        .on('end', function (d) {
            for (const i in d.data) {
                if (!d.data.hasOwnProperty(i)) {
                    continue;
                }
                
                delete d.data[i].dx;
                delete d.data[i].dy;
                
                editor.options.$sideBar.fire('point:selected', {
                    data:  {
                        x: d.data[i].x,
                        y: d.data[i].y
                    },
                    index: i
                });
            }
    
            editor.options.$sideBar.fire('point:unselect');
            editor.unselectDraggable();
            
            // After the coordinates have been set, refresh the editor.
            editor.process();
        });
}

function floorplanLayoutFormDragMove(editor) {
    var tmp = {};
    
    return d3.drag()
        .on('start', function (d) {
            tmp.transform = Object.clone(d.transform);
            tmp.x = d.transform.x;
            tmp.y = d.transform.y;
        })
        .on('drag', function (d) {
            tmp.x = d3.event.x.toFixed(2).toFloat();
            tmp.y = d3.event.y.toFixed(2).toFloat();
            
            if (editor.options.snapToGrid) {
                tmp.x = Math.round(tmp.x / 10) * 10;
                tmp.y = Math.round(tmp.y / 10) * 10;
            }
            
            // transform.a => scale, transform.e => translate x, transform.f => translate y
            d.$form.attr('transform', 'translate(' + tmp.x + ',' + tmp.y + ')scale(' + tmp.transform.k + ')rotate(' + tmp.transform.r + ')');
        })
        .on('end', function (d) {
            d.setTransform({x: tmp.x, y: tmp.y, k: tmp.transform.k, r: tmp.transform.r});
    
            editor.options.$sideBar.fire('form:selected', {form: editor.selectedForm});
            
            editor.process();
        });
}