/**
 * i-doit "circle" javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.FloorplanFormsCircle = Class.create(window.FloorplanFormsMaster, {
    type: 'circle',
    
    initialize: function ($super) {
        $super();
        
        this.options = {
            radius: 8
        };
    },
    
    update: function () {
        this.$form
            .attr('transform', this.getTransformString())
            .select('circle')
            .attr('r', this.options.radius)
            .style('fill', this.style.fill)
            .style('fill-opacity', this.style.fillOpacity)
            .style('stroke', this.style.stroke)
            .style('stroke-width', this.style.strokeWidth);
    
        return this.$form
    },
    
    render: function () {
        this.$form = d3.create('svg:g')
            .attr('class', 'object');
        
        this.$form.append('circle');
        
        return this.update();
    }
});