/**
 * i-doit "door-left" javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.FloorplanFormsDoorLeft = Class.create(window.FloorplanFormsMaster, {
    type: 'door-left',
    
    initialize: function ($super) {
        $super();
        
        this.options = {
            size: 24
        };
    },
    
    update: function () {
        const that = this;
        
        const translation = parseInt((that.options.size * -.5) / 10) * 10;
        
        this.$form
            .attr('transform', this.getTransformString())
            .call(function ($group) {
                $group.select('polygon.helper')
                    .attr('points', '0,0 0,' + that.options.size + ' ' + (that.options.size * .725) + ',' + (that.options.size * .725));
            })
            .call(function ($group) {
                $group.select('line.frame')
                    .attr('x1', 0)
                    .attr('y1', 0)
                    .attr('x2', 0)
                    .attr('y2', that.options.size)
                    .style('stroke', that.style.stroke)
                    .style('stroke-width', that.style.strokeWidth);
            })
            .call(function ($group) {
                $group.select('line.door')
                    .attr('x1', 0)
                    .attr('y1', 0)
                    .attr('x2', that.options.size * .725)
                    .attr('y2', that.options.size * .725)
                    .style('stroke', that.style.stroke)
                    .style('stroke-width', that.style.strokeWidth * .5);
            })
            .call(function ($group) {
                $group.select('path')
                    .attr('d', window.FloorplanHelper.describeArc(0, 0, that.options.size, 135, 180))
                    .style('stroke', that.style.stroke)
                    .style('stroke-width', that.style.strokeWidth * .5);
            })
            .selectAll('*')
            .attr('transform', 'translate(' + translation + ',' + translation + ')');
    
        return this.$form
    },
    
    render: function () {
        this.$form = d3.create('svg:g')
            .attr('class', 'object');
    
        this.$form
            .append('polygon')
            .attr('class', 'helper')
            .style('stroke', 'none')
            .style('fill', 'transparent');
        
        this.$form
            .append('line')
            .attr('class', 'frame');
        
        this.$form
            .append('line')
            .attr('class', 'door');
        
        this.$form
            .append('path')
            .style('fill', 'none')
            .style('stroke-dasharray', '2 2');
        
        return this.update();
    }
});