/**
 * i-doit "rect" javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.FloorplanFormsRect = Class.create(window.FloorplanFormsMaster, {
    type: 'rect',
    
    initialize: function ($super) {
        $super();
        
        this.options = {
            width:  24,
            height: 24
        };
    },
    
    update: function () {
        this.$form
            .attr('transform', this.getTransformString())
            .select('rect')
            .attr('transform', 'translate(' + (this.options.width*-.5) + ',' + (this.options.height*-.5) + ')')
            .attr('width', this.options.width)
            .attr('height', this.options.height)
            .style('fill', this.style.fill)
            .style('fill-opacity', this.style.fillOpacity)
            .style('stroke', this.style.stroke)
            .style('stroke-width', this.style.strokeWidth);
    
        return this.$form
    },
    
    render: function () {
        this.$form = d3.create('svg:g')
            .attr('class', 'object');
        
        this.$form.append('rect');
        
        return this.update();
    }
});