/**
 * i-doit "circle" javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.FloorplanVisualizationTypePlain = Class.create(window.FloorplanVisualizationTypeMaster, {
    update: function (options) {
        if (!this.ready) {
            return;
        }
        
        const that = this;
        
        Object.extend(this.options, options || {transition: false});
        
        this.$container
            .style('opacity', function (d) { return d.visibility; })
            .interrupt()
            .transition()
            .duration(that.options.transition ? 400 : 0)
            .attr('transform', function (d) {
                return 'translate(' + d.x + ',' + d.y + ')rotate(' + d.angle + ')';
            });
        
        this.$container.selectAll('.inner-content')
            .interrupt()
            .transition()
            .duration(that.options.transition ? 400 : 0)
            .attr('transform', function (d) {
                return 'rotate(-' + d.angle + ')';
            });
        
        this.$container.select('polygon')
            .attr('points', function (d) {
                var points = d.polygon || window.floorPlanDefaults.polygon;
                
                return points.map(function (point) {
                    return (point.x / 200) * d.width + ',' + (point.y / 200) * d.height
                }).join(' ');
            });
        
        this.$container.select('.title')
            .text(function (d) {
                return FloorplanHelper.getObjectType(d.objType).title;
            })
            .attr('x', function (d) {
                return -(this.getComputedTextLength() / 2);
            });
        
        this.$container.select('.object-title')
            .text(function (d) {
                return d.objTitle;
            })
            .attr('x', function (d) {
                return -(this.getComputedTextLength() / 2);
            });
        
        this.$container.select('image.object-type-icon')
            .attr('x', function (d) {
                return that.$container.select('text.title').attr('x') - 22;
            });
        
        this.$container
            .select('.orientation')
            .attr('d', window.FloorplanHelper.processOrientation);
        
        this.$container.selectAll('.rotate-image,.toggle-floorplan').dispatch('update:position');
        
        // Re-position the scale circles and drag-element.
        this.renderDragArea();
    },
    
    render: function () {
        this.$container.append('polygon')
            .attr('class', 'mouse-pointer')
            .attr('fill', function (d) {
                return FloorplanHelper.getObjectType(d.objType).color;
            });
        
        this.$container.append('g')
            .attr('class', 'inner-content')
            .attr('transform', function (d) {
                return 'rotate(-' + d.angle + ')'
            })
            .call(function ($innerContent) {
                $innerContent.append('text')
                    .attr('class', 'title mouse-pointer')
                    .attr('y', -5)
                    .style('fill', function (d) {
                        if (Color.calc_color_light(FloorplanHelper.getObjectType(d.objType).color) < 61) {
                            return '#ffffff';
                        }
                        
                        return null;
                    });
                
                $innerContent.append('text')
                    .attr('class', 'object-title mouse-pointer')
                    .attr('y', 10)
                    .style('fill', function (d) {
                        if (Color.calc_color_light(FloorplanHelper.getObjectType(d.objType).color) < 61) {
                            return '#fff';
                        }
                        
                        return null;
                    });
                
                // The image needs to be positioned left of the title - so we'll have to wait until the text has been placed.
                $innerContent.append('image')
                    .attr('class', 'object-type-icon mouse-pointer')
                    .attr('width', 16)
                    .attr('height', 16)
                    .attr('y', -18)
                    .attr('xlink:href', function (d) {
                        return FloorplanHelper.getObjectType(d.objType).icon;
                    });
            });
        
        this.$container
            .append('path')
            .attr('class', 'orientation');
        
        this.ready = true;
        this.update();
    }
});
