<?php

/**
 * i-doit
 *
 * Auth: Class for i-doit authorization rules.
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.5
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.5
 */
class isys_auth_floorplan extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var  isys_auth_floorplan
     */
    private static $instance;

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     * @throws Exception
     */
    public function get_auth_methods()
    {
        return [
            'visualization' => [
                'title'   => 'LC__MODULE__FLOORPLAN__AUTH__VISUALIZATION',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::EDIT, isys_auth::DELETE],
                'default' => [isys_auth::VIEW]
            ],
            'floorplan_profiles' => [
                'title'   => 'LC__MODULE__FLOORPLAN__AUTH__PROFILES',
                'type'    => 'boolean',
                'rights'  => [isys_auth::VIEW, isys_auth::CREATE, isys_auth::EDIT, isys_auth::DELETE, isys_auth::SUPERVISOR],
            ]
        ];
    }

    /**
     * Method for checking, if the user is allowed to process the visualization.
     *
     * @param   integer $right
     *
     * @return  boolean
     * @throws  isys_exception_auth
     */
    public function visualization($right)
    {
        if (!$this->is_auth_active()) {
            return true;
        }

        return $this->generic_right(
            $right,
            'visualization',
            self::EMPTY_ID_PARAM,
            new isys_exception_auth(isys_application::instance()->container->get('language')->get('You are not allowed to execute the visualization.'))
        );
    }

    /**
     * Get ID of related module.
     *
     * @return  integer
     */
    public function get_module_id()
    {
        return C__MODULE__FLOORPLAN;
    }

    /**
     * Get title of related module.
     *
     * @return  string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__FLOORPLAN';
    }

    /**
     * Retrieve singleton instance of authorization class.
     *
     * @return isys_auth_floorplan
     * @author Leonard Fischer <lfischer@i-doit.com>
     */
    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$instance === null) {
            self::$instance = new self;
        }

        return self::$instance;
    }
}
