<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_floorplan_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/floorplan/';
        $classMap = [
            'isys_auth_floorplan'                 => 'auth/isys_auth_floorplan.class.php',
            'isys_cmdb_dao_category_g_floorplan'  => 'cmdb/dao/global/isys_cmdb_dao_category_g_floorplan.class.php',
            'isys_cmdb_ui_category_g_floorplan'   => 'cmdb/ui/global/isys_cmdb_ui_category_g_floorplan.class.php',
            'isys_popup_floorplan_export'         => 'src/popup/isys_popup_floorplan_export.class.php',
            'isys_popup_floorplan_layout_editor'  => 'src/popup/isys_popup_floorplan_layout_editor.class.php',
            'isys_popup_floorplan_object_radius'  => 'src/popup/isys_popup_floorplan_object_radius.class.php',
            'isys_popup_floorplan_polygon_editor' => 'src/popup/isys_popup_floorplan_polygon_editor.class.php',
            'isys_popup_floorplan_profile'        => 'src/popup/isys_popup_floorplan_profile.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
