<?php

namespace idoit\Module\Floorplan\Controller;

use idoit\Module\Floorplan\Model\Tree as TreeModel;
use idoit\Module\Floorplan\Model\TreeParentResolver;
use isys_format_json as JSON;
use isys_register as Register;

/**
 * i-doit cmdb controller
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Tree extends Ajax
{
    /**
     * Method for retrieving child locations for the location tree.
     *
     * @param Register $request
     */
    public function getChildLocations(Register $request)
    {
        try {
            $mode = $request->get('POST')->get('mode');

            $objectId = (int)$request->get('id');

            $locationModel = new TreeModel($this->getDi()->get('database'));

            switch ($mode) {
                default:
                case C__FLOORPLAN__LOCATION_VIEW__LOCATIONS:
                    $this->response['data'] = $locationModel->getLocationChildren($objectId, 1);
                    break;

                case C__FLOORPLAN__LOCATION_VIEW__FLOORPLANS:
                    $this->response['data'] = $locationModel->getFloorplans();
                    break;

                case C__FLOORPLAN__LOCATION_VIEW__FLOORPLAN_OBJECTS:
                    $this->response['data'] = $locationModel->getFloorplanObjects($objectId);
                    break;
            }
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * This method returns an array of ids and how many of the positioned objects are located underneath.
     *
     * @param Register $request
     */
    public function getPositionedObjectTreeHierarchy(Register $request)
    {
        try {
            $objects = [];
            $positionedObjects = $request->get('POST')
                ->get('positionedObjects');

            if (JSON::is_json_array($positionedObjects)) {
                $objects = JSON::decode($positionedObjects);
            }

            if (count($objects)) {
                $this->response['data'] = (new TreeParentResolver($this->getDi()->get('database')))->parents($objects);
            }
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }
}
