[{isys_group name="tom.popup.floorplan"}]
<div id="floorplan-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__EXPORT__POPUP_TITLE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content p5">
        <h4 class="border gradient p5">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__EXPORT__POPUP_EXPORT_TYPE"}]</h4>

        <label class="display-block ml5">
            <input type="radio" name="floorplan-popup-export-type" class="mr5" value="png-full" checked="checked" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__PNG_FULL"}]</span>
        </label>

        <label class="display-block mt5 ml5">
            <input type="radio" name="floorplan-popup-export-type" class="mr5" value="png" />
            <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__EXPORT__POPUP_EXPORT_PNG_FILE"}]</span>
        </label>

        <label class="display-block mt5 ml5">
            <input type="radio" name="floorplan-popup-export-type" class="mr5" value="svg-full" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__SVG_FULL"}]</span>
        </label>

        <label class="display-block mt5 ml5">
            <input type="radio" name="floorplan-popup-export-type" class="mr5" value="svg" />
            <span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__EXPORT__POPUP_EXPORT_SVG_FILE"}]</span>
        </label>

    </div>

    <div class="popup-footer-ng">
        <button type="button" class="btn mr5" id="floorplan-popup-save">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__EXPORT__POPUP_EXPORT_BUTTON"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL_CLOSE"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        var $popup         = $('floorplan-popup'),
            $accept_button = $('floorplan-popup-save'),
            $canvas        = $('floorplan-visualization-canvas');

        $popup.select('.popup-closer').invoke('on', 'click', function () {
            popup_close();
        });

        $accept_button.on('click', function () {
            var date        = new Date(),
                export_type = $popup.down('[name="floorplan-popup-export-type"]:checked').getValue(),
                fileName    = 'floorplan-export_' + date.getFullYear() + '-' + ('0' + (1 + date.getMonth())).substr(-2, 2) + '-' + ('0' + date.getDate()).substr(-2, 2);

            switch (export_type)
            {
                case 'png-full':
                    window.FloorplanHelper.prepareFullSvg($canvas).saveToPng({filename: fileName, scale: 2});
                    break;

                case 'svg-full':
                    window.FloorplanHelper.prepareFullSvg($canvas).saveToSvg({filename: fileName});
                    break;

                case 'png':
                    $('floorplan-visualization-canvas')
                        .down('svg')
                        .saveToPng({
                            filename: fileName,
                            scale:    2
                        });
                    break;

                case 'svg':
                    $('floorplan-visualization-canvas')
                        .down('svg')
                        .saveToSvg({filename: fileName});
                    break;
            }
        });
    })();
</script>
[{/isys_group}]
