/**
 * i-doit Floorplan JS component for dragging objects.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
function floorplanDragMove(floorplan) {
    var tmp;
    
    return d3.drag()
        .on('start', function (d) {
            var $objectNode = floorplan.vis.select('.level-' + floorplan.uuid + '[data-id="' + d.objId + '"]');
    
            // Hide all scaling points
            $objectNode.selectAll('.scale-circle,.rotate-image,.toggle-floorplan').classed('hide', true);
            
            // I use this "tmp" variable for various things during dragging.
            tmp = {
                $object:    $objectNode,
                clientX:    d3.event.sourceEvent.clientX,
                clientY:    d3.event.sourceEvent.clientY,
                objX:       parseFloat(d.x),
                objY:       parseFloat(d.y),
                scale:      floorplan.getCurrentCanvasZoom(),
                userScale:  floorplan.getUserScale(false),
                grid:       floorplan.getGridSize(),
                snapToGrid: floorplan.options.snapToGrid
            };
            
            floorplan.vis.classed('currently-dragging', true);
        })
        .on('drag', function (d) {
            var deltaX = parseFloat(d3.event.sourceEvent.clientX - tmp.clientX),
                deltaY = parseFloat(d3.event.sourceEvent.clientY - tmp.clientY);
            
            d.x = tmp.objX + (deltaX / tmp.scale);
            d.y = tmp.objY + (deltaY / tmp.scale);
            
            if (tmp.snapToGrid) {
                d.x -= d.x % (tmp.grid * tmp.userScale);
                d.y -= d.y % (tmp.grid * tmp.userScale);
            }
            
            floorplan.updateObjectPositions(d.objId);
        })
        .on('end', function (d) {
            floorplan.vis.classed('currently-dragging', false);
            
            tmp.$object.selectAll('.scale-circle,.rotate-image,.toggle-floorplan').classed('hide', false);
    
            floorplan.updateObjectPositions(d.objId);
            
            tmp = null;
        });
}
