/**
 * i-doit object radius editor javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.ObjectRadius = Class.create({
    options: {},
    
    initialize: function ($el, options) {
        var x = 100, y = 100;
        
        this.$element = $el;
        this.options = {
            polygon: false,
            objectTypeColor: '#fff',
            displayRadius: true,
            radiusRadius: 190,
            radiusColor: '#ffffff',
            radiusOpacity: 50
        };
        
        this.width = this.$element.getWidth();
        this.height = this.$element.getHeight();
        
        Object.extend(this.options, options || {});
        
        // Initialize the SVG element.
        this.svg = d3.select($el).append('svg')
            .attr('width', this.width)
            .attr('height', this.height)
            .append('g')
            .attr('transform', 'translate(' + (this.width / 2) + ',' + (this.height / 2) + ')');
        
        this.vis = this.svg.append('g');
        
        this.$radius = this.vis.append('circle');
        
        this.$polygon = this.vis.append('polygon');
        
        this.line = d3.line()
            .x(function (d) { return d.x; })
            .y(function (d) { return d.y; })
            .curve(d3.curveLinearClosed);
        
        // We display a rectangle by default.
        if (!this.options.polygon) {
            this.options.polygon = [{x: -x, y: -y}, {x: x, y: -y}, {x: x, y: y}, {x: -x, y: y}];
        }
        
        this.process();
        
        return this;
    },
    
    displayRadius: function (display) {
        this.options.displayRadius = display;
        this.process();
        
        return this;
    },
    
    setColor: function (color) {
        this.options.radiusColor = color;
        this.process();
        
        return this;
    },
    
    setOpacity: function (opacity) {
        this.options.radiusOpacity = opacity;
        this.process();
        
        return this;
    },
    
    process: function () {
        this.$polygon
            .datum(this.options.polygon)
            .attr('fill', this.options.objectTypeColor || '#fff')
            .attr('points', function (d) {
                return d.map(function (d) {
                    return d.x + ',' + d.y
                }).join(' ');
            });
        
        this.$radius
            .attr('r', this.options.displayRadius ? this.options.radiusRadius : 0)
            .style('fill', this.options.radiusColor)
            .style('fill-opacity', this.options.radiusOpacity / 100);
        
        return this;
    }
});
