/**
 * i-doit visualization type factory javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
createVisualizationType = function ($container, data, options) {
    if (options.floorplanLevel < 3 && data.visualizeAsFloorplan && data.hasOwnFloorplan && (data.hasOwnLayout || data.hasOwnBackgroundImage)) {
        return new window.FloorplanVisualizationTypeFloorplan($container, data, options);
    }
    
    return new window.FloorplanVisualizationTypePlain($container, data, options);
};

window.FloorplanVisualizationTypeMaster = Class.create({
    initialize: function ($container, data, options) {
        this.$container = d3.select($container);
        this.data = data;
        this.options = options;
        this.ready = false;
    },
    
    update: function (options) {
        throw 'Implement the update method';
    },
    
    render: function () {
        throw 'Implement the render method';
    },
    
    renderDragArea: function () {
        this.$container.selectAll('.scale-circle')
            .attr('class', function (d, i) {
                // If we hide the point, don't run any additional logic.
                if (d3.select(this).classed('hide')) {
                    return 'scale-circle hide';
                }
                
                const directions = ['n', 'ne', 'e', 'se', 's', 'sw', 'w', 'nw'];
                let relativeRotation = d.angle + 22.5;
                
                if (relativeRotation >= 360) {
                    relativeRotation -= 360;
                }
                
                i += Math.floor(relativeRotation / 45);
                
                if (i >= 8) {
                    i -= 8;
                }
                
                return 'scale-circle mouse-move-' + directions[i];
            })
            .attr('transform', function (d, i) {
                // If we hide the point, don't run any additional logic.
                if (d3.select(this).classed('hide')) {
                    return null;
                }
                
                /*
                 * "circlePositions" contains all eight positions of the point.
                 * -1,-1    0,-1    1,-1
                 * -1, 0            1, 0
                 * -1, 1    0, 1    1, 1
                 */
                const scalePositions = [[0, -1], [1, 0], [0, 1], [-1, 0]];
                const scaleCornerPositions = [[1, -1], [1, 1], [-1, 1], [-1, -1]];
                const index = Math.floor(i / 2);
                
                if (i % 2 === 0) {
                    return 'translate(' + [scalePositions[index][0] * (d.width / 2), scalePositions[index][1] * (d.height / 2)] + ')';
                }
                
                return 'translate(' + [scaleCornerPositions[index][0] * (d.width / 2), scaleCornerPositions[index][1] * (d.height / 2)] + ')';
            });
        
        this.$container.select('[data-role="drag-object"]')
            .attr('x', function (d) {
                return -(d.width / 2);
            })
            .attr('y', function (d) {
                return -(d.height / 2);
            })
            .attr('width', function (d) {
                return d.width;
            })
            .attr('height', function (d) {
                return d.height;
            });
    }
});
