<?php

use idoit\AddOn\AuthableInterface;

/**
 * i-doit
 *
 * Floorplan module class
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_floorplan extends isys_module implements AuthableInterface
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = true;
    const DISPLAY_IN_SYSTEM_MENU = false;
    const MAIN_MENU_REWRITE_LINK = true;

    /**
     * Initializes the module.
     *
     * @param   isys_module_request $request
     *
     * @return  isys_module_floorplan
     */
    public function init(isys_module_request $request)
    {
        return $this;
    }

    /**
     * @return isys_auth_floorplan
     */
    public static function getAuth()
    {
        return isys_auth_floorplan::instance();
    }
}
