<?php

namespace idoit\Module\Floorplan\Controller;

use Exception;
use idoit\Controller\Base;
use idoit\Module\Floorplan\Model\Dao;
use idoit\Tree\Node;
use isys_application as Application;
use isys_component_template_navbar as Navbar;
use isys_component_tree as Tree;
use isys_controller as Controller;
use isys_module as Module;
use isys_module_floorplan;
use isys_register as Register;

/**
 * i-doit cmdb controller
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Main extends Base implements Controller
{
    /**
     * @var Module
     */
    protected $module;

    /**
     * Default request handler, gets called in every /floorplan request.
     *
     * @param   Register    $request
     * @param   Application $application
     *
     * @return  \idoit\View\Renderable|void
     */
    public function handle(Register $request, Application $application)
    {
        Navbar::getInstance()->hide_all_buttons();

        header('Location: ' . $application->www_path . 'floorplan/visualization/0');
    }

    /**
     * @param   Application $application
     *
     * @return  \idoit\Module\Floorplan\Model\Dao
     * @throws  Exception
     */
    public function dao(Application $application)
    {
        return Dao::instance($this->getDi()->get('database'));
    }

    /**
     * Build the left tree.
     *
     * @param   Register    $request
     * @param   Application $application
     * @param   Tree        $tree
     *
     * @return  Node
     * @throws  Exception
     */
    public function tree(Register $request, Application $application, Tree $tree)
    {
        return new Node(
            $this->getDi()->get('language')->get('LC__MODULE__FLOORPLAN'),
            '',
            isys_module_floorplan::getWwwPath() . 'assets/add-on-icon.svg');
    }

    /**
     * Constructor method.
     *
     * @param  Module $module
     */
    public function __construct(Module $module)
    {
        $this->module = $module;
    }
}
