<?php

namespace idoit\Module\Floorplan\Controller;

use idoit\Module\Floorplan\View\Visualization as VisualizationView;
use isys_application as Application;
use isys_cmdb_dao_category_g_images as DaoImages;
use isys_register as Register;

/**
 * i-doit cmdb controller
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Visualization extends Main
{
    /**
     * Default handler for displaying the visualization GUI.
     *
     * @param   Register    $request
     * @param   Application $application
     *
     * @return  VisualizationView
     */
    public function handle(Register $request, Application $application)
    {
        return new VisualizationView($request);
    }

    /**
     * Method for displaying a image from the "images" category.
     *
     * @param  Register $request
     *
     * @throws \Exception
     */
    public function backgroundImage(Register $request)
    {
        echo (new DaoImages($this->getDi()->get('database')))->load_image((int)$request->get('id'));

        die;
    }
}
