<?php

/**
 * i-doit
 *
 * Floorplan export popup.
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_floorplan_export extends isys_component_popup
{
    /**
     * @var  isys_component_template
     */
    protected $template;

    /**
     * @var  isys_component_template_language_manager
     */
    protected $language;

    /**
     * Constructor method.
     *
     * @throws Exception
     */
    public function __construct()
    {
        parent::__construct();

        $this->template = isys_application::instance()->container->get('template');
        $this->language = isys_application::instance()->container->get('language');
    }

    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param   isys_component_template &$template
     * @param   array                   $parameters
     *
     * @return  string
     */
    public function handle_smarty_include(isys_component_template &$template, $parameters)
    {
        global $g_dirs;

        $urlParameter = C__CMDB__VISUALIZATION_VIEW . '=' . $_GET[C__CMDB__VISUALIZATION_VIEW] .
            '&' . C__CMDB__VISUALIZATION_TYPE . '=' . $_GET[C__CMDB__VISUALIZATION_TYPE];

        $buttonParameters = [
            'id'                => $parameters['name'],
            'p_strClass'        => 'fr btn mr5',
            'icon'              => $g_dirs['images'] . 'axialis/basic/symbol-download.svg',
            'p_bInfoIconSpacer' => 0,
            'p_onClick'         => $this->process_overlay($urlParameter, 500, 300, $parameters),
            'type'              => 'button',
            'p_strTitle'        => $this->language->get('LC__VISUALIZATION_EXPORT')
        ];

        return isys_factory::get_instance('isys_smarty_plugin_f_button')
            ->navigation_edit($this->template, $buttonParameters);
    }

    /**
     * Method for handling the module request.
     *
     * @param  isys_module_request $request
     *
     * @return void
     * @throws Exception
     */
    public function &handle_module_request(isys_module_request $request)
    {
        $this->template
            ->activate_editmode()
            ->display(isys_module_floorplan::getPath() . 'templates/popup/export.tpl');
        die;
    }
}
