<div id="floorplan-visualization">
    <div id="floorplan-visualization-overlay">
        <div>
            <img src="[{$dir_images}]ajax-loading.gif"
                 class="vam mr5"/><span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__LOADING_PLEASE_WAIT"}]</span>
        </div>
    </div>

    <div id="floorplan-visualization-canvas">
        <div id="floorplan-startup" class="popup custom-popup hide">
            <div class="popup-header-ng">
                <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__STARTUP__TITLE"}]</h1>
                <em class="ml-auto text-neutral-400">v[{$floorplanVersion}]</em>
            </div>

            <div class="popup-content p5">
                <div style="float:left; width:49%;">
                    <p>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__STARTUP__LAST_UPDATED_OBJECTS"}]</p>

                    <ul class="list-style-none">
                        [{foreach $latestUpdatedObjects as $floorplan}]
                        <li>
                            <a href="javascript:window.initializeFloorplan([{$floorplan.objectId}])" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION__FUNCTION_OPEN_FLOORPLAN"}]">
                                <img src="[{$floorplan.objectTypeIcon}]" class="mr5 vam" title="[{$floorplan.objectTypeTitle}]">
                                [{$floorplan.objectTitle}]
                            </a>
                            [{if $floorplan.floorplanSnapshot}]
                            <button type="button" class="btn btn-secondary floorplan-preview" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__STARTUP__PREVIEW"}]" data-tooltip="1">
                                <img src="[{$dir_images}]axialis/basic/zoom.svg" akt="" />
                            </button>
                            <img src="[{$floorplan.floorplanSnapshot}]" class="hide" />
                            [{/if}]
                        </li>
                        [{/foreach}]
                    </ul>
                </div>
                <div style="float:right; width:49%;">
                    <p>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__STARTUP__LAST_CREATED_OBJECTS"}]</p>

                    <ul class="list-style-none">
                        [{foreach $latestCreatedObjects as $floorplan}]
                        <li>
                            <a href="javascript:window.initializeFloorplan([{$floorplan.objectId}])" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION__FUNCTION_OPEN_FLOORPLAN"}]">
                                <img src="[{$floorplan.objectTypeIcon}]" class="mr5 vam" title="[{$floorplan.objectTypeTitle}]">
                                [{$floorplan.objectTitle}]
                            </a>
                            [{if $floorplan.floorplanSnapshot}]
                            <button type="button" class="btn btn-secondary floorplan-preview" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__STARTUP__PREVIEW"}]" data-tooltip="1">
                                <img src="[{$dir_images}]axialis/basic/zoom.svg" akt="" />
                            </button>
                            <img src="[{$floorplan.floorplanSnapshot}]" class="hide" />
                            [{/if}]
                        </li>
                        [{/foreach}]
                    </ul>
                </div>
            </div>
        </div>
        <div id="startup-preview-container" class="hide">
            <div id="startup-preview"></div>
        </div>
    </div>

    <div id="floorplan-visualization-measurement" class="popup custom-popup hide" style="height:240px">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__SET_FLOORPLAN_SCALE"}]</h1>
        </div>

        <div class="popup-content p5">
            [{isys type="f_label" name="floorplan_measurement_display" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__SCALE_POSITION"}]
            [{isys type="f_dialog" name="floorplan_measurement_display"}]

            <p class="mt10 mb5">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__CHOSEN_DISTANCE_EQUAL_TO" p_bHtmlEncode=false}]...</p>

            [{isys type="f_text" name="floorplan_measurement_count"}]
            [{isys type="f_dialog" name="floorplan_measurement_unit"}]
        </div>

        <div class="popup-footer">
            <button type="button" class="btn mr5" data-action="accept">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
            </button>

            <button type="button" class="btn" data-action="abort">
                <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
            </button>
        </div>
    </div>

    <div id="floorplan-visualization-layer-browser" class="popup custom-popup hide">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__LAYER_BROWSER"}]</h1>
        </div>

        <div class="popup-content p5">
            <button type="button" class="btn hide" data-action="new-layer">
                <img src="[{$dir_images}]axialis/basic/symbol-add.svg" /><span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__LAYER_BROWSER__CREATE_NEW"}]</span>
            </button>

            <div class="layer-container"></div>
        </div>
    </div>

    <div id="floorplan-visualization-background-popup" class="popup custom-popup hide">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__EDIT_BACKGROUND"}]</h1>
        </div>

        <div class="popup-content p5">
            <div id="floorplan-visualization-background-upload-wrapper" class="mb5"><!-- To be filled by JS --></div>
            <p>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__BACKGROUND_IMAGE_EXPLANATION" p_bHtmlEncode=false}]</p>

            <div id="floorplan-visualization-background-gallery">
                <!-- To be filled by JS -->
            </div>
        </div>

        <div class="popup-footer-ng">
            <button type="button" class="btn mr5" data-action="accept">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
            </button>

            <button type="button" class="btn" data-action="abort">
                <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
            </button>

            <button type="button" class="btn ml-auto" data-action="remove">
                <img src="[{$dir_images}]axialis/basic/symbol-remove.svg" /><span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__BACKGROUND_IMAGE_REMOVE_FROM_FLOORPLAN"}]</span>
            </button>
        </div>
    </div>
</div>

<style type="text/css">
    #floorplan-visualization .handle {
        width: 8px;
        height: 16px;
        background: url('[{$dir_images}]icons/hatch.gif');
    }

    [{include file="`$assets_dir`/css/visualization.css"}]
</style>

<script>
    (function () {
        'use strict';

        window.floorplanWwwPath = '[{isys_module_floorplan::getWwwPath()}]';

        var initialParameters = window.location.href.parseQuery(),
            initialHighlight = initialParameters.hasOwnProperty('highlight') ? parseInt(initialParameters.highlight) : null,
            initialObjectAddition = initialParameters.hasOwnProperty('addObject') ? JSON.parse(initialParameters.addObject) : null;

        jscolor.dir = window.dir_images + 'jscolor/';

        // Adding some translations.
        idoit.Translate.set('LC_UNIVERSAL__ABORT', '[{isys type="lang" ident="LC_UNIVERSAL__ABORT" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC_UNIVERSAL__ACCEPT', '[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__UNIVERSAL__BACK', '[{isys type="lang" ident="LC__UNIVERSAL__BACK" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__UNIVERSAL__ERROR', '[{isys type="lang" ident="LC__UNIVERSAL__ERROR" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC_FILEBROWSER__DROP_FILE', '[{isys type="lang" ident="LC_FILEBROWSER__DROP_FILE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__WHD', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__WHD" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__WEIGHT', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__WEIGHT" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__SAVING', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__SAVING" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC_FILEBROWSER__SINGLE_FILE_UPLOAD', '[{isys type="lang" ident="LC_FILEBROWSER__SINGLE_FILE_UPLOAD" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_EDITOR__MAX_POINTS_SET', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__MAX_POINTS_SET" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_EDITOR__MIN_POINTS_SET', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__MIN_POINTS_SET" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__UPLOAD_IMAGE_ERROR', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__UPLOAD_IMAGE_ERROR" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__SET_FLOORPLAN_SCALE_CONFIRM', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__SET_FLOORPLAN_SCALE_CONFIRM" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__INHERIT_FORMFACTOR_DATA_TITLE', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__INHERIT_FORMFACTOR_DATA_TITLE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__INHERIT_FORMFACTOR_DATA_CONFIRM', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__INHERIT_FORMFACTOR_DATA_CONFIRM" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__MISSING_OBJECT_TYPE', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__MISSING_OBJECT_TYPE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__MISSING_OBJECT_TYPE_DESCRIPTION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__MISSING_OBJECT_TYPE_DESCRIPTION" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__AUTH__MISSING_VISUALIZATION_RIGHT', '[{$authEditErrorMessage}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__AUTH__MISSING_DELETION_RIGHT', '[{$authDeleteErrorMessage}]');
        // GUI specific translations.
        idoit.Translate.set('LC_UNIVERSAL__DELETE', '[{isys type="lang" ident="LC_UNIVERSAL__DELETE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__UNIVERSAL__FILE_ADD', '[{isys type="lang" ident="LC__UNIVERSAL__FILE_ADD" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__SAVED', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__SAVED" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__SNAPSHOT_SAVED', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__SNAPSHOT_SAVED" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__SNAPSHOT_COULD_NOT_BE_SAVED', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__SNAPSHOT_COULD_NOT_BE_SAVED" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__DELETED', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__DELETED" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__BACKGROUND_IMAGE_REMOVE_CONFIRM', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__BACKGROUND_IMAGE_REMOVE_CONFIRM" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__SAVE_FORMFACTOR_DATA_CONFIRM', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__SAVE_FORMFACTOR_DATA_CONFIRM" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__OBJECT_INFORMATION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__OBJECT_INFORMATION" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__LEAVE_WITHOUT_SAVE_NOTIFICATION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__LEAVE_WITHOUT_SAVE_NOTIFICATION" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__FORMFACTOR_VALUES_INCORRECT', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__FORMFACTOR_VALUES_INCORRECT" p_bHtmlEncode=false}]');
        // Tree specific translations.
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__POSITION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__POSITION" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__UNPOSITION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__UNPOSITION" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__POSITION_ALL', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__POSITION_ALL" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__UNPOSITION_ALL', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__UNPOSITION_ALL" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__TAB__LOCATION__FUNCTION_OPEN_FLOORPLAN', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__TAB__LOCATION__FUNCTION_OPEN_FLOORPLAN" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__CATEGORY__CREATE_FLOORPLAN', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__CATEGORY__CREATE_FLOORPLAN" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP__DELETE_CONFIRMATION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP__DELETE_CONFIRMATION" p_bHtmlEncode=false}]');
        // Layer specific translations
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__LAYER_BROWSER__DELETE_CONFIRMATION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__LAYER_BROWSER__DELETE_CONFIRMATION" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__VISUALIZATION__LAYER_BROWSER__TOGGLE_VISIBILITY', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__VISUALIZATION__LAYER_BROWSER__TOGGLE_VISIBILITY" p_bHtmlEncode=false}]');
        // Layout specific translations
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__RECTANGLE', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__RECTANGLE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__CIRCLE', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__CIRCLE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR__OPENES_LEFT', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR__OPENES_LEFT" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR__OPENES_RIGHT', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR__OPENES_RIGHT" p_bHtmlEncode=false}]');

        // Global data-store for our reloaded script files.
        window.floorplanData = {
            authDelete:            !!parseInt('[{$authDelete}]'),
            authEdit:              !!parseInt('[{$authEdit}]'),
            initialHighlight:      initialHighlight,
            initialObjectAddition: initialObjectAddition,
            objectId:              parseInt('[{$objectId}]'),
            objectTypeData:        JSON.parse('[{$objectTypeData|json_encode|escape:"javascript"}]'),
            profiles:              JSON.parse('[{$profiles|json_encode|escape:"javascript"}]'),
            rootObjectId:          parseInt('[{$smarty.const.C__OBJ__ROOT_LOCATION}]'),
            scaleFactors:          JSON.parse('[{$scaleFactors|json_encode|escape:"javascript"}]'),
            wwwPath:               '[{isys_module_floorplan::getWwwPath()}]'
        };

        const requirements = {
            'fileUploader': null,
            'd3': null,
            'treeBase': null,
            'floorplan.drag-move': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-drag-move.js',
            'floorplan.drag-scale': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-drag-scale.js',
            'floorplan.drag-rotate': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-drag-rotate.js',
            'floorplan.floorplan': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan.js',
            'floorplan.layer-editor': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-layer-editor.js',
            'floorplan.tree': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-tree.js',
            'floorplan.helper': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-helper.js',
            'floorplan.forms.factory': '[{isys_module_floorplan::getWwwPath()}]assets/js/forms/factory.js',
            'floorplan.forms.circle': '[{isys_module_floorplan::getWwwPath()}]assets/js/forms/circle.js',
            'floorplan.forms.door-left': '[{isys_module_floorplan::getWwwPath()}]assets/js/forms/door-left.js',
            'floorplan.forms.door-right': '[{isys_module_floorplan::getWwwPath()}]assets/js/forms/door-right.js',
            'floorplan.forms.rect': '[{isys_module_floorplan::getWwwPath()}]assets/js/forms/rect.js',
            'floorplan.forms.square': '[{isys_module_floorplan::getWwwPath()}]assets/js/forms/square.js',
            'floorplan.visualization-types.factory': '[{isys_module_floorplan::getWwwPath()}]assets/js/visualization-types/factory.js',
            'floorplan.visualization-types.floorplan': '[{isys_module_floorplan::getWwwPath()}]assets/js/visualization-types/floorplan.js',
            'floorplan.visualization-types.plain': '[{isys_module_floorplan::getWwwPath()}]assets/js/visualization-types/plain.js',
            'floorplan.gui': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-gui.js'
        };

        for (const key in requirements) {
            if (requirements.hasOwnProperty(key) && requirements[key]) {
                idoit.Require.addModule(key, requirements[key]);
            }
        }

        // We use the "requireQueue" to go sure that "floorplan.gui" will be loaded last.
        idoit.Require.requireQueue(Object.keys(requirements), function () {
            var $tabContainer = $('floorplan-visualization-left-tabs');

            new Tabs($tabContainer, {
                wrapperClass: 'browser-tabs',
                contentClass: 'browser-tab-content',
                tabClass: 'mouse-pointer'
            });

            if (initialHighlight || initialObjectAddition) {
                $tabContainer.down('li a').simulate('click');
            } else {
                $tabContainer.down('li a', 1).simulate('click');
            }
        });

        const $previewContainer = $('startup-preview-container');

        $('floorplan-startup').on('click', '.floorplan-preview', function (ev) {
            const $previewContainerInner = $('startup-preview');
            const $previewImage = ev.findElement('button').next().clone(true);

            $previewContainer.removeClassName('hide');
            $previewContainerInner.update($previewImage.removeClassName('hide'));

        });

        $previewContainer.on('click', function () {
            $previewContainer.down('img').remove();
            $previewContainer.addClassName('hide');
        });
    })();
</script>
