/**
 * i-doit Floorplan JS component for scaling objects.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
function floorplanDragScale(floorplan) {
    var tmp;
    
    return d3.drag()
        .on('start', function (d) {
            var $objectNode = floorplan.vis.select('.level-' + floorplan.uuid + '[data-id="' + d.objId + '"]'),
                transform = d3.zoomTransform(floorplan.svg.node());
            
            // Hide all scaling points
            $objectNode.selectAll('.scale-circle,.rotate-image,.toggle-floorplan').classed('hide', true);
    
            // But still display the current one.
            d3.select(this).classed('hide', false);
            
            // I use this "tmp" variable for various things during dragging.
            tmp = {
                $object:   $objectNode,
                dragStyle: d3.select(this).attr('data-role')
            };
        }).on('drag', function (d) {
            var mouse = d3.mouse(tmp.$object.node()),
                hypothenuse = FloorplanHelper.distanceBetweenPoints([0, 0], mouse),
                beta = FloorplanHelper.angleBetweenPoints([0, 0], mouse),
                dx = hypothenuse * Math.cos(beta),
                dy = hypothenuse * Math.sin(beta);
            
            switch (tmp.dragStyle) {
                case 'scale-n':
                    d.height = -2 * dy;
                    break;
                case 'scale-ne':
                    d.width = 2 * dx;
                    d.height = -2 * dy;
                    break;
                case 'scale-e':
                    d.width = 2 * dx;
                    break;
                case 'scale-se':
                    d.width = 2 * dx;
                    d.height = 2 * dy;
                    break;
                case 'scale-s':
                    d.height = 2 * dy;
                    break;
                case 'scale-sw':
                    d.width = -2 * dx;
                    d.height = 2 * dy;
                    break;
                case 'scale-w':
                    d.width = -2 * dx;
                    break;
                case 'scale-nw':
                    d.width = -2 * dx;
                    d.height = -2 * dy;
                    break;
            }
            
            if (d.width < 16) {
                d.width = 16;
            }
            
            if (d.height < 16) {
                d.height = 16;
            }
            
            floorplan.updateObjectPositions(d.objId, false);
        }).on('end', function (d) {
            // Show all scale circles.
            tmp.$object.selectAll('.scale-circle,.rotate-image,.toggle-floorplan').classed('hide', false);
        
            floorplan.updateObjectPositions(d.objId);
            
            tmp = null;
        });
}
