/**
 * i-doit "square" javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
window.FloorplanFormsSquare = Class.create(window.FloorplanFormsMaster, {
    type: 'square',
    
    initialize: function ($super) {
        $super();
        
        this.options = {
            size: 24
        };
    },
    
    update: function () {
        this.$form
            .attr('transform', this.getTransformString())
            .select('rect')
            .attr('transform', 'translate(' + (this.options.size*-.5) + ',' + (this.options.size*-.5) + ')')
            .attr('width', this.options.size)
            .attr('height', this.options.size)
            .style('fill', this.style.fill)
            .style('fill-opacity', this.style.fillOpacity)
            .style('stroke', this.style.stroke)
            .style('stroke-width', this.style.strokeWidth);
    
        return this.$form
    },
    
    render: function () {
        this.$form = d3.create('svg:g')
            .attr('class', 'object');
        
        this.$form.append('rect');
        
        return this.update();
    }
});