<?php

/**
 * i-doit
 *
 * Floorplan Module initializer
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.2
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Module\Floorplan\Model\FloorplanObject;

if (isys_module_manager::instance()->is_active('floorplan')) {
    \idoit\Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Floorplan', __DIR__ . '/src/');

    include_once __DIR__ . '/isys_module_floorplan_autoload.class.php';

    spl_autoload_register('isys_module_floorplan_autoload::init');

    define('C__FLOORPLAN__LOCATION_VIEW__LOCATIONS', 'locations');
    define('C__FLOORPLAN__LOCATION_VIEW__FLOORPLANS', 'floorplans');
    define('C__FLOORPLAN__LOCATION_VIEW__FLOORPLAN_OBJECTS', 'floorplan-objects');

    isys_application::instance()->container->get('signals')->connect(
        'mod.cmdb.afterCategoryEntrySave',
        function (\isys_cmdb_dao_category $dao, $categoryID, $saveSuccess, $objectID, $posts, $changes) {
            if ($dao instanceof isys_cmdb_dao_category_g_location) {
                $db = isys_application::instance()->container->get('database');
                $language = isys_application::instance()->container->get('language');
                $floorplanResult = FloorplanObject::instance($db)->getFloorplansByObject($objectID);
                $parentLocation = (int)$dao->get_parent_id_by_object($objectID);
                while ($floorplanRow = $floorplanResult->get_row()) {
                    $parentFloorplanId = (int)$floorplanRow['objectId'];
                    // Check if the location parent of "$objectId" is different in the floorplan and notify
                    if ($parentFloorplanId !== $parentLocation) {
                        $floorplanUrl = isys_helper_link::get_base() . '/floorplan/visualization/' . $parentFloorplanId;
                        isys_notify::warning(
                            $language->get('LC__MODULE__FLOORPLAN__VISUALIZATION__OBJECT_REMAINS_AFTER_RELOCATION') .
                            ': <a target="_blank" href="' . $floorplanUrl . '">Floorpaln #' . $parentFloorplanId . '</a>',
                            ['sticky' => true]
                        );
                    }
                }
            }
        }
    );
}
