<?php

namespace idoit\Module\Floorplan\Controller;

use idoit\Module\Floorplan\Model\Floorplan;
use idoit\Module\Floorplan\Model\Layer as LayerModel;
use isys_format_json as JSON;
use isys_register as Register;

/**
 * i-doit cmdb controller
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Layer extends Ajax
{
    /**
     * @param Register $request
     */
    public function save(Register $request)
    {
        try {
            $post = $request->get('POST');
            $floorplanModel = Floorplan::instance($this->getDi()->get('database'));
            $layerModel = LayerModel::instance($this->getDi()->get('database'));

            // First find out the floorplan ID.
            $floorplanId = $floorplanModel
                ->getFloorplanByObjectId($post['floorplanObjectId'])
                ->get_row_value('isys_floorplan__id');

            $layerData = [
                'isys_floorplan_layers__isys_floorplan__id' => $floorplanId
            ];

            if (isset($post['layerTitle']) && !empty($post['layerTitle'])) {
                $layerData['isys_floorplan_layers__title'] = trim($post['layerTitle']);
            }

            if (isset($post['layerColor']) && !empty($post['layerColor'])) {
                $layerData['isys_floorplan_layers__color'] = trim($post['layerColor']);
            }

            if (isset($post['layerSort']) && is_numeric($post['layerSort'])) {
                $layerData['isys_floorplan_layers__sort'] = (int)$post['layerSort'];
            }

            if (isset($post['layerConfig']) && JSON::is_json_array($post['layerConfig'])) {
                $layerData['isys_floorplan_layers__configuration'] = JSON::decode($post['layerConfig']);
            }

            $layerModel->saveLayer((int)$post['layerId'], $layerData);

            $layers = [];
            $layerRes = $layerModel->getData('AND isys_floorplan_layers__isys_floorplan__id = ' . $layerModel->convert_sql_id($floorplanId));

            while ($row = $layerRes->get_row()) {
                $layers[$row['id']] = $row;
                $layers[$row['id']]['configuration'] = JSON::decode($row['configuration']);
            }

            $this->response['data'] = array_values($layers);
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }

    /**
     * @param Register $request
     */
    public function delete(Register $request)
    {
        try {
            $post = $request->get('POST');
            $layerModel = LayerModel::instance($this->getDi()->get('database'));

            $floorplanId = $layerModel
                ->getData('AND isys_floorplan_layers__id = ' . $layerModel->convert_sql_id($post['layerId']))
                ->get_row_value('floorplanId');
            $layerModel->deleteLayer((int)$post['layerId']);

            $layers = [];
            $layerRes = $layerModel->getData('AND isys_floorplan_layers__isys_floorplan__id = ' . $layerModel->convert_sql_id($floorplanId));

            while ($row = $layerRes->get_row()) {
                $layers[$row['id']] = $row;
                $layers[$row['id']]['configuration'] = JSON::decode($row['configuration']);
            }

            $this->response['data'] = array_values($layers);
        } catch (\Exception $e) {
            $this->response['success'] = false;
            $this->response['message'] = $e->getMessage();
        }
    }
}
