<?php

namespace idoit\Module\Floorplan\Model;

use idoit\Model\Dao\Base;
use isys_application as Application;
use isys_format_json as JSON;
use isys_helper_color;

/**
 * i-doit Floorplan Model
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Format extends Base
{
    /**
     * Method for retrieving object data in our specific format.
     *
     * @param int  $objectId
     * @param bool $includeSnapshot
     *
     * @return array
     * @throws \idoit\Exception\JsonException
     * @throws \isys_exception_database
     */
    public function object(int $objectId, bool $includeSnapshot = false)
    {
        $language = Application::instance()->container->get('language');

        $selectFields = [
            'isys_obj__id'                  => 'objectId',
            'isys_obj__title'               => 'objectTitle',
            'isys_obj_type__id'             => 'objectTypeId',
            'isys_obj_type__title'          => 'objectTypeTitle',
            'isys_obj_type__color'          => 'objectTypeColor',
            'isys_obj_type__container'      => 'isContainer',
            'isys_floorplan__id'            => 'hasOwnFloorplan',
            'isys_floorplan__layout'        => 'hasOwnLayout',
            'isys_floorplan__configuration' => 'configuration'
        ];

        if ($includeSnapshot) {
            $selectFields['isys_floorplan__snapshot'] = 'floorplanSnapshot';
        }

        $select = parent::selectImplode($selectFields);

        $sql = 'SELECT ' . $select . '
            FROM isys_obj
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            LEFT JOIN isys_floorplan ON isys_floorplan__isys_obj__id = isys_obj__id
            WHERE isys_obj__id = ' . $this->convert_sql_id($objectId) . ';';

        $result = $this->retrieve($sql)->get_row();

        $configuration = ['backgroundImageSize' => null];

        if (JSON::is_json_array($result['configuration'])) {
            $configuration = JSON::decode($result['configuration']);
        }

        unset($result['configuration']);

        $result['objectId'] = (int)$result['objectId'];
        $result['objectTypeId'] = (int)$result['objectTypeId'];
        $result['objectTypeColor'] = isys_helper_color::unifyHexColor((string)$result['objectTypeColor']);
        $result['objectTypeIcon'] = self::objectTypeIconPath((int)$result['objectTypeId']);
        $result['isContainer'] = (bool)$result['isContainer'];
        $result['hasOwnFloorplan'] = (bool)$result['hasOwnFloorplan'];
        $result['hasOwnLayout'] = (bool)$result['hasOwnLayout'];
        $result['hasOwnBackgroundImage'] = $configuration['backgroundImageSize'];
        $result['hasChildren'] = false;
        $result['children'] = [];
        $result['objectTypeTitle'] = $language->get($result['objectTypeTitle']);

        // Also add "nodeId" for the tree.
        $result['nodeId'] = $result['objectId'];

        return $result;
    }

    /**
     * Convenience method for getting the correct object type icon URL.
     *
     * @param int $objectTypeId
     *
     * @return string
     * @throws \Exception
     */
    public static function objectTypeIconPath(int $objectTypeId): string
    {
        return Application::instance()->container->get('route_generator')->generate('cmdb.object-type.icon', ['objectTypeId' => $objectTypeId]);
    }
}
