<?php

/**
 * i-doit
 *
 * Floorplan polygon editor popup.
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_floorplan_object_radius extends isys_component_popup
{
    /**
     * @var  isys_component_template
     */
    protected $template;

    /**
     * Constructor method.
     *
     * @throws Exception
     */
    public function __construct()
    {
        parent::__construct();

        $this->template = isys_application::instance()->container->get('template');
    }

    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param isys_component_template $template
     * @param array                   $parameters
     *
     * @return string
     * @throws Exception
     */
    public function handle_smarty_include(isys_component_template &$template, $parameters)
    {
        // This is never used - the popup will directly be triggered via JS callback.
    }

    /**
     * Method for handling the module request.
     *
     * @param isys_module_request $request
     *
     * @return isys_component_template|void
     * @throws \idoit\Exception\JsonException
     */
    public function &handle_module_request(isys_module_request $request)
    {
        $parameters = isys_format_json::decode(base64_decode($_POST['popupData']));

        $rules = [
            'floorplan-object-radius-radius' => [
                'p_bInfoIconSpacer' => 0,
                'disableInputGroup' => true,
                'p_strValue'        => $parameters['radius']['radius'] ?: 1,
                'allowZero'         => true
            ],
            'floorplan-object-radius-unit'  => [
                'p_bInfoIconSpacer'  => 0,
                'disableInputGroup'  => true,
                'p_bSort'            => false,
                'p_bDbFieldNN'       => true,
                'p_strSelectedID'    => $parameters['radius']['unit'] ?: 'm',
                'p_arData'           => [
                    'cm' => 'LC__DEPTH_UNIT__CM',
                    'in' => 'LC__DEPTH_UNIT__INCH',
                    'ft' => 'LC__DEPTH_UNIT__FOOT',
                    'm'  => 'LC__DEPTH_UNIT__METER',
                ]
            ],
            'floorplan-object-radius-color' => [
                'p_strValue'  => $parameters['radius']['color'] ?: '#ffffff',
                'placeholder' => '#ffffff',
                'size'        => 'mini',
                'parent'      => '#floorplan-object-radius-popup .popup-content',
            ],
            'floorplan-object-radius-opacity' => [
                'p_bInfoIconSpacer'  => 0,
                'disableInputGroup'  => true,
                'p_bSort'            => false,
                'p_bDbFieldNN'       => true,
                'p_strSelectedID'    => $parameters['radius']['opacity'] ?: '50',
                'p_arData'           => [
                    100 => '0%',
                    90 => '10%',
                    80 => '20%',
                    70 => '30%',
                    60 => '40%',
                    50 => '50%',
                    40 => '60%',
                    30 => '70%',
                    20 => '80%',
                    10 => '90%',
                ]
            ]
        ];

        $this->template->activate_editmode()
            ->assign('objectPolygon', $parameters['polygon'])
            ->assign('objectTypeColor', isys_helper_color::unifyHexColor((string)$parameters['objectTypeColor']))
            ->smarty_tom_add_rules('tom.popup.floorplan', $rules)
            ->display(isys_module_floorplan::getPath() . 'templates/popup/object-radius.tpl');
        die;
    }
}
