<?php

use idoit\Module\Floorplan\Model\Profile;

/**
 * i-doit
 *
 * Floorplan polygon editor popup.
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_floorplan_profile extends isys_component_popup
{
    /**
     * Variable which holds the CMDB-Explorer profiles.
     *
     * @var  array
     */
    protected $m_profiles = [];

    /**
     * Handles SMARTY request for dialog plus lists and builds the list base on the specified table.
     *
     * @param   isys_component_template &$templateComponent
     * @param   array                   $parameters
     *
     * @return  string
     */
    public function handle_smarty_include(isys_component_template &$templateComponent, $parameters)
    {
        global $g_dirs;

        $profiles = [];
        $profilesResult = (new Profile($this->database))->getProfiles();

        while ($profilesRow = $profilesResult->get_row()) {
            $profiles[$profilesRow['id']] = $profilesRow['title'];
        }

        $button = '';

        $dialogOptions = [
            'name'              => $parameters['name'],
            'p_strSelectedID'   => (int)isys_usersettings::get('floorplan.default-profile', 0),
            'p_bInfoIconSpacer' => 0,
            'p_arData'          => [
                $this->language->get('LC__VISUALIZATION_PROFILES') => $profiles
            ],
            'p_bSort'           => false,
            'p_bDbFieldNN'      => true,
            'disableInputGroup' => true,
            'p_strTitle'        => $this->language->get('LC__VISUALIZATION_PROFILES'),
            'nowiki'            => $parameters['nowiki']
        ];

        if (isys_auth_floorplan::instance()->is_allowed_to(isys_auth::VIEW, 'floorplan_profiles')) {
            $button = '<button type="button" class="btn" title="' . $this->language->get('LC__FLOORPLAN_PROFILE__DESCRIPTION') . '" onclick="' . $this->process_overlay('', '50%', '50%', $parameters, 'popup_commentary', 640, 480, 1000, 700) . '" data-tooltip="1">' .
                '<img src="' . $g_dirs['images'] . 'axialis/documents-folders/document-edit.svg" alt="" />' .
                '</button>';
        }

        return isys_factory::get_instance('isys_smarty_plugin_f_dialog')
                ->navigation_edit($this->template, $dialogOptions) . $button;
    }

    /**
     * Method for handling the module request.
     *
     * @param   isys_module_request $p_modreq
     *
     * @return  null
     */
    public function &handle_module_request(isys_module_request $p_modreq)
    {
        $profiles = [];
        $profilesResult = (new Profile($this->database))->getProfiles();

        while ($profilesRow = $profilesResult->get_row()) {
            $profilesRow['id'] = (int) $profilesRow['id'];
            $profilesRow['translatedTitle'] = $this->language->get($profilesRow['title']);
            $profilesRow['selfdefined'] = empty($profilesRow['const']);
            $profilesRow['config'] = isys_format_json::decode($profilesRow['config']);
            unset($profilesRow['status'], $profilesRow['const']);

            $profiles[] = $profilesRow;
        }

        $this->template->activate_editmode()
            ->assign('create_right', (int) isys_auth_floorplan::instance()->is_allowed_to(isys_auth::CREATE, 'floorplan_profiles'))
            ->assign('edit_right', (int) isys_auth_floorplan::instance()->is_allowed_to(isys_auth::EDIT, 'floorplan_profiles'))
            ->assign('delete_right', (int) isys_auth_floorplan::instance()->is_allowed_to(isys_auth::DELETE, 'floorplan_profiles'))
            ->assign('admin_right', (int) isys_auth_floorplan::instance()->is_allowed_to(isys_auth::SUPERVISOR, 'floorplan_profiles'))
            ->assign('profiles', $profiles)
            ->assign('defaultProfile', (int)isys_usersettings::get('floorplan.default-profile', 0))
            ->assign('ajaxSmartyUrl', isys_helper_link::create_url([C__GET__AJAX_CALL => 'smartyplugin', C__GET__AJAX => 1]))
            ->smarty_tom_add_rules('tom.popup.floorplan', $this->prepareSmartyRules())
            ->display(isys_module_floorplan::getPath() . 'templates/popup/profile.tpl');

        die;
    }

    /**
     * Method for loading all necessary smarty rules for the given profile.
     *
     * @return  array
     */
    protected function prepareSmartyRules()
    {
        $objectTypes = [];

        $l_object_types = isys_cmdb_dao::instance($this->database)
            ->get_object_type();

        if (is_array($l_object_types) && count($l_object_types)) {
            foreach ($l_object_types as $l_object_type) {
                $objectTypes[$l_object_type['isys_obj_type__id']] = $l_object_type['LC_isys_obj_type__title'];
            }
        }

        return [
            'C__FLOORPLAN_PROFILE__TITLE'                      => [
                'p_strClass'       => 'input input-small',
                'p_strPlaceholder' => 'LC__FLOORPLAN_PROFILE__TITLE',
                'p_strValue'       => ''
            ],
            'C__FLOORPLAN_PROFILE__HIGHLIGHT_COLOR'            => [
                'size'   => 'mini',
                'parent' => '#floorplan-profile-popup .popup-content'
            ],
            'C__FLOORPLAN_PROFILE__DISPLAY_RADIUS'             => [
                'p_strClass'   => 'input-mini',
                'p_bDbFieldNN' => true,
                'p_arData'     => get_smarty_arr_YES_NO()
            ],
            'C__FLOORPLAN_PROFILE__CHANGE_TAB_ON_OBJ_SELECT'   => [
                'p_strClass'   => 'input-mini',
                'p_bDbFieldNN' => true,
                'p_arData'     => get_smarty_arr_YES_NO()
            ],
            'C__FLOORPLAN_PROFILE__DBL_CLICK_TO_OPEN_OBJECT'   => [
                'p_strClass'   => 'input-mini',
                'p_bDbFieldNN' => true,
                'p_arData'     => get_smarty_arr_YES_NO()
            ],
            'C__FLOORPLAN_PROFILE__DEFAULT_OBJECT_TYPE_FILTER' => [
                'p_strClass'   => 'input-small',
                'p_multiple'   => true,
                'p_bDbFieldNN' => true,
                'p_arData'     => $objectTypes
            ]
        ];
    }
}
