[{isys_group name="tom.popup.floorplan"}]
<div id="floorplan-polygon-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_POLYGON__HEADER"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <div id="floorplan-polygon-popup-functions" class="p5 border-bottom">
            <div class="input-group input-size-mini">
                [{isys type="f_dialog" name="floorplan-polygon-popup-selection"}]

                <div class="input-group-addon input-group-addon-clickable" data-action="remove-selfdefined" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__REMOVE_BUTTON_TITLE"}]">
                    <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" />
                </div>
            </div>

            <div id="floorplan-polygon-popup-selfdefined" class="hide fr">
                <div class="input-group input-size-small">
                    [{isys type="f_text" name="floorplan-polygon-popup-selfdefined-title"}]

                    <div class="input-group-addon input-group-addon-clickable" data-action="save-selfdefined">
                        <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" />
                    </div>
                </div>
            </div>

            <br class="cb" />
        </div>
        <div id="floorplan-polygon-popup-canvas"></div>
    </div>

    <div class="popup-footer-ng">
        <button type="button" class="btn mr5" id="floorplan-popup-save">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        var $popup                   = $('floorplan-polygon-popup'),
            $canvas                  = $('floorplan-polygon-popup-canvas'),
            $functionsBar            = $('floorplan-polygon-popup-functions'),
            $polygonSelection        = $('floorplan-polygon-popup-selection'),
            $selfdefined             = $('floorplan-polygon-popup-selfdefined'),
            $selfdefinedName         = $('floorplan-polygon-popup-selfdefined-title'),
            $selfdefinedSaveButton   = $functionsBar.down('[data-action="save-selfdefined"]'),
            $selfdefinedRemoveButton = $functionsBar.down('[data-action="remove-selfdefined"]'),
            $accept_button           = $('floorplan-popup-save'),
            polygonEditor,
            polygons                 = JSON.parse('[{$polygons|escape:"javascript"}]'),
            $selectedObjectPolygon   = $('selectedObjectPolygon'),
            objectPolygon            = false;

        idoit.Require
            .addModule('floorplan.polygon-editor', '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-polygon-editor.js')
            .addModule('floorplan.helper', '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-helper.js');

        idoit.Require.require(['floorplan.polygon-editor', 'floorplan.helper'], function () {
            $popup.select('.popup-closer').invoke('on', 'click', function () {
                popup_close();
            });

            $selfdefined.on('hide:selfdefinedForm', function () {
                $selfdefined.addClassName('hide');
            });

            $selfdefined.on('show:selfdefinedForm', function () {
                $selfdefined.removeClassName('hide');
                $polygonSelection.setValue('selfdefined');
            });

            $selfdefinedName.on('keydown', function (ev) {
                // Do not allow the default behaviour for "ENTER".
                if (ev.keyCode == Event.KEY_RETURN) {
                    ev.preventDefault();

                    $selfdefinedSaveButton.simulate('click');
                }
            });

            $selfdefinedSaveButton.on('click', function () {
                if ($selfdefinedName.getValue().blank() || $selfdefinedSaveButton.retrieve('in-action')) {
                    idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_POLYGON__FORM_NAME_REMINDER"}]');
                    return;
                }

                $selfdefinedSaveButton.store('in-action', true).down('img')
                    .addClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/user-interface/loading.svg');

                new Ajax.Request('[{$ajax_url}]', {
                    parameters: {
                        action: 'savePolygon',
                        name:   $selfdefinedName.getValue(),
                        data:   JSON.stringify(polygonEditor.getData())
                    },
                    onComplete: function (response) {
                        var json = response.responseJSON;

                        $selfdefinedName.setValue('');
                        $selfdefinedSaveButton.store('in-action', false).down('img')
                            .removeClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/basic/symbol-ok.svg');
                        $selfdefined.fire('hide:selfdefinedForm');

                        if (!is_json_response(response, true)) {
                            return;
                        }

                        if (json.success) {
                            polygons = json.data.polygons;

                            $polygonSelection.fire('update:polygonSelection');
                            $polygonSelection.setValue(json.data.newId);
                            polygonEditor.setOption('polygons', polygons);
                        } else {
                            idoit.Notify.error(json.message, {sticky: true});
                        }
                    }
                });
            });

            $selfdefinedRemoveButton.on('click', function () {
                if (!confirm('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__REMOVE_BUTTON_CONFIRM" p_bHtmlEncode=false}]')) {
                    return;
                }

                new Ajax.Request('[{$ajax_url}]', {
                    parameters: {
                        action:    'removePolygon',
                        polygonId: $polygonSelection.getValue()
                    },
                    onComplete: function (response) {
                        var json = response.responseJSON;

                        if (!is_json_response(response, true)) {
                            return;
                        }

                        if (json.success) {
                            if (json.data === true) {
                                $polygonSelection.down('option:selected').remove();
                                $polygonSelection.simulate('change');

                                idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__REMOVE_SUCCESS"}]');
                            } else {
                                idoit.Notify.warning(json.data);
                            }
                        } else {
                            idoit.Notify.error(json.message, {sticky: true});
                        }
                    }
                });
            });

            $polygonSelection.on('change', function () {
                var value = $polygonSelection.getValue();

                if (value === 'selfdefined') {
                    $selfdefined.fire('show:selfdefinedForm');
                } else {
                    $selfdefined.fire('hide:selfdefinedForm');
                    polygonEditor.loadPolygon(value);
                }
            });

            $polygonSelection.on('update:polygonSelection', function (ev) {
                var i, val = $polygonSelection.getValue();

                if (!val && ev.memo.selfdefined) {
                    val = 'selfdefined';
                }

                $polygonSelection.update();

                for (i in polygons) {
                    if (polygons.hasOwnProperty(i)) {
                        $polygonSelection.insert(new Element('option', {value: polygons[i].id}).update(polygons[i].title))
                    }
                }

                $polygonSelection
                    .insert(new Element('option', {value: 'selfdefined'}).update('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__POLYGON_SELFDEFINED"}]'))
                    .setValue(val);
            });

            $accept_button.on('click', function () {
                // This function can be found in "visualization_gui.js".
                window.setObjectPolygon(polygonEditor.getData());

                popup_close();
            });

            $canvas.on('init:polygonEditor', function () {
                polygonEditor.process();
            });

            if ($selectedObjectPolygon) {
                try {
                    objectPolygon = JSON.parse($selectedObjectPolygon.getValue());
                } catch (e) {
                    objectPolygon = false;
                }
            }

            polygonEditor = new PolygonEditor($canvas, {
                objectId:              '[{$object.objId}]',
                objectTitle:           '[{$object.objTitle}]',
                objectTypeTitle:       '[{$object.objTypeTitle}]',
                objectTypeColor:       '[{$object.objTypeColor}]',
                objectTypeIcon:        '[{$object.objTypeIcon}]',
                maxPointsNotification: '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__MAX_POINTS_SET"}]',
                polygons:              polygons,
                objectPolygon:         objectPolygon,
                onPointAfterDrag:      function () {
                    $selfdefined.fire('show:selfdefinedForm');
                },
                onPointAfterAdd:       function () {
                    $selfdefined.fire('show:selfdefinedForm');
                },
                onPointAfterRemove:    function () {
                    $selfdefined.fire('show:selfdefinedForm');
                }
            });

            $polygonSelection.fire('update:polygonSelection', {selfdefined: !!objectPolygon});
            $canvas.fire('init:polygonEditor');
        });
    })();
</script>
<style>
    #floorplan-polygon-popup {
        box-sizing: border-box;
        position: relative;
        height: 100%;
    }

    #floorplan-polygon-popup-canvas {
        position: absolute;
        top: 43px;
        right: 0;
        bottom: 0;
        left: 0;
        background: #eee url('[{$dir_images}]10x10-grid.gif') repeat scroll -51px -2px;
    }

    #floorplan-polygon-popup-canvas text {
        fill: #000;
        stroke: none;
        user-select: none;
        -ms-user-select: none;
        -webkit-user-select: none;
        -moz-user-select: none;
    }

    #floorplan-polygon-popup-canvas circle.dragger,
    #floorplan-polygon-popup-canvas circle.adder {
        stroke: #888;
        stroke-width: 3px;
        fill: transparent;
        cursor: pointer;
    }

    #floorplan-polygon-popup-canvas circle.dragger:hover {
        stroke: #5897fb;
    }

    #floorplan-polygon-popup-canvas polygon {
        stroke: #000;
        stroke-width: 1px;
        fill-opacity: 0.75;
    }

    #floorplan-polygon-popup-canvas path {
        stroke: none;
        fill: none;
    }

    #floorplan-polygon-popup-canvas rect.boundaries {
        fill: none;
        stroke: #f00;
        stroke-dasharray: 3, 10;
        stroke-linecap: round;
        stroke-width: 3px;
    }
</style>
[{/isys_group}]
