/**
 * i-doit layout editor javascript class.
 *
 * @author  Leonard Fischer <lfischer@i-doit.com>
 */
createForm = function (type) {
    switch (type) {
        default:
            return new window.FloorplanFormsMaster();
    
        case 'square':
            return new window.FloorplanFormsSquare().setOptions({size:40});
            
        case 'rect':
            return new window.FloorplanFormsRect().setOptions({width:40, height:20});
        
        case 'circle':
            return new window.FloorplanFormsCircle().setOptions({radius:20});
        
        case 'door-left':
            return new window.FloorplanFormsDoorLeft().setOptions({size: 90});
        
        case 'door-right':
            return new window.FloorplanFormsDoorRight().setOptions({size: 90});
    }
};

window.FloorplanFormsMaster = Class.create({
    initialize: function () {
        this.options = {};
        this.style = {};
        this.transform = {x: 0, y: 0, k: 1, r:0};
        
        // Small 'random ID' generator, by https://gist.github.com/gordonbrander/2230317
        this.id = '_' + Math.random().toString(36).substr(2, 9);
    },
    
    setOptions: function (options) {
        Object.extend(this.options, options || {});
        
        return this;
    },
    
    setStyle: function (style) {
        Object.extend(this.style, style || {});
        
        return this;
    },
    
    setTransform: function (transform) {
        Object.extend(this.transform, transform || {})
        
        return this;
    },
    
    getTransformString: function () {
        return 'translate(' + this.transform.x + ',' + this.transform.y + ')scale(' + this.transform.k + ')rotate(' + this.transform.r + ')';
    },
    
    update: function () {
        this.$form
            .attr('transform', this.getTransformString())
            .select('text')
            .attr('x', 0)
            .attr('y', 8)
            .attr('text-anchor', 'middle')
            .text('?')
            .style('font-size', 15)
            .style('fill', '#000000')
            .style('fill-opacity', 1)
            .style('stroke', 'none');
    
        return this.$form
    },
    
    render: function () {
        this.$form = d3.create('svg:g')
            .attr('class', 'object');
        
        this.$form.append('text');
        
        return this.update();
    }
});