<?php

use idoit\Module\Floorplan\Model\Floorplan;
use idoit\Module\Floorplan\Model\FloorplanObject;
use idoit\Module\Floorplan\Model\Format;

/**
 * i-doit
 *
 * CMDB Floorplan category.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_g_floorplan extends isys_cmdb_ui_category_g_virtual
{
    /**
     * Process method.
     *
     * @param  isys_cmdb_dao_category $categoryDao
     *
     * @return void
     * @throws isys_exception_database
     */
    public function process(isys_cmdb_dao_category $categoryDao)
    {
        $objectId = (int)$categoryDao->get_object_id();
        $assignedFloorplans = [];
        $floorplanObjectModel = new FloorplanObject($this->m_database_component);

        $floorplanResult = $floorplanObjectModel->getFloorplansByObject($objectId);

        while ($floorplanRow = $floorplanResult->get_row()) {
            $floorplanRow['objectTypeIcon'] = Format::objectTypeIconPath((int)$floorplanRow['objectTypeId']);

            $assignedFloorplans[] = $floorplanRow;
        }

        $parentLocation = $floorplanObjectModel->getParentLocationInformation($objectId)->get_row();

        $parentLocation['objectTypeIcon'] = Format::objectTypeIconPath((int)$parentLocation['objectTypeId']);

        $hasOwnFloorplan = (new Floorplan($this->m_database_component))->getFloorplanByObjectId($objectId);

        // Hide all functional buttons (for example "edit").
        isys_component_template_navbar::getInstance()
            ->hide_all_buttons();

        $objectData = Format::instance($this->m_database_component)->object($objectId);
        $objectTypeIcon = $objectData['objectTypeIcon'];
        unset($objectData['objectTypeColor'], $objectData['objectTypeIcon'], $objectData['hasChildren'], $objectData['children']);

        // Deactivate the commentary and assign some template variables.
        $this->deactivate_commentary()
            ->get_template_component()
            ->assign('objectData', $objectData)
            ->assign('objectTypeIcon', $objectTypeIcon)
            ->assign('hasOwnFloorplan', (bool)count($hasOwnFloorplan))
            ->assign('assignedFloorplans', $assignedFloorplans)
            ->assign('parentLocation', $parentLocation)
            ->assign('floorplanUrl', isys_application::instance()->www_path . 'floorplan/visualization/');
    }

    /**
     * Get path to template file.
     *
     * @return  string
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
    public function get_template()
    {
        return isys_module_floorplan::getPath() . 'templates/catg__floorplan.tpl';
    }
}
