<?php

namespace idoit\Module\Floorplan\Model;

use idoit\Model\Dao\Base;

/**
 * i-doit Floorplan Model
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class FloorplanObject extends Base
{
    /**
     * Get floorplans, which contain the given object.
     *
     * @param  integer $objectId
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getFloorplansByObject($objectId)
    {
        $selects = $this->selectImplode([
            'isys_floorplan__id'      => 'id',
            'isys_floorplan__updated' => 'updated',
            'isys_obj__id'            => 'objectId',
            'isys_obj__title'         => 'objectTitle',
            'isys_obj_type__title'    => 'objectTypeTitle',
            'isys_obj_type__id'       => 'objectTypeId'
        ]);

        $sql = 'SELECT ' . $selects . '
            FROM isys_floorplan_objects
            INNER JOIN isys_floorplan ON isys_floorplan__id = isys_floorplan_objects__isys_floorplan__id
            INNER JOIN isys_obj ON isys_obj__id = isys_floorplan__isys_obj__id
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            WHERE isys_floorplan_objects__isys_obj__id = ' . $this->convert_sql_id($objectId) . ';';

        return $this->retrieve($sql);
    }

    /**
     * Get information about the parent location of a given object.
     *
     * @param  integer $objectId
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getParentLocationInformation($objectId)
    {
        $selects = $this->selectImplode([
            'isys_floorplan__id'   => 'floorplanId',
            'isys_obj__id'         => 'objectId',
            'isys_obj__title'      => 'objectTitle',
            'isys_obj_type__title' => 'objectTypeTitle',
            'isys_obj_type__id'    => 'objectTypeId'
        ]);

        $sql = 'SELECT ' . $selects . '
            FROM isys_catg_location_list
            INNER JOIN isys_obj ON isys_obj__id = isys_catg_location_list__parentid
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            LEFT JOIN isys_floorplan ON isys_floorplan__isys_obj__id = isys_catg_location_list__parentid
            WHERE isys_catg_location_list__isys_obj__id = ' . $this->convert_sql_id($objectId) . ';';

        return $this->retrieve($sql);
    }
}
