<?php

namespace idoit\Module\Floorplan\Model;

use idoit\Model\Dao\Base;

/**
 * i-doit TreeParentResolver Model
 *
 * @package     Modules
 * @subpackage  Floorplan
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class TreeParentResolver extends Base
{
    /**
     * @var array
     */
    private $counterMap = [];

    /**
     * @param  array $ids
     *
     * @return array
     */
    public function parents(array $ids)
    {
        $parents = [];
        $result = [];

        // First we find all parents of the given objects.
        $this->findParents($ids, $parents);

        // Now we calculate all counters.
        $this->prepareCounter($ids, $parents);

        foreach ($this->counterMap as $objectId => $count) {
            if ($count) {
                $result['n' . $objectId] = $count;
            }
        }

        return $result;
    }

    /**
     * @param  array $ids
     * @param  array $data
     *
     * @return array
     */
    private function prepareCounter(array $ids, array $data)
    {
        $result = [];

        foreach ($ids as $id) {
            if (!isset($data[$id]['parents']) || !is_array($data[$id]['parents'])) {
                continue;
            }

            $data[$id]['parents'] = array_unique(array_filter($data[$id]['parents']));

            foreach ($data[$id]['parents'] as $parent) {
                if (!isset($this->counterMap[$parent])) {
                    $this->counterMap[$parent] = 0;
                }

                $this->counterMap[$parent]++;
            }

            $this->prepareCounter($data[$id]['parents'], $data);
        }

        return $result;
    }

    /**
     * Find parents by ids.
     *
     * @param array $ids
     * @param array &$parents
     */
    private function findParents(array $ids, array &$parents)
    {
        if (empty($ids)) {
            return;
        }

        $found = [];

        $sql = 'SELECT isys_catg_logical_unit_list__isys_obj__id__parent as parent,
            isys_catg_logical_unit_list__isys_obj__id as id
            FROM isys_catg_logical_unit_list
            LEFT JOIN isys_obj on isys_catg_logical_unit_list__isys_obj__id__parent = isys_obj__id
            WHERE isys_catg_logical_unit_list__isys_obj__id ' . $this->prepare_in_condition($ids) . ' 
            UNION
            SELECT isys_catg_location_list__parentid as parent,
            isys_catg_location_list__isys_obj__id as id
            FROM isys_catg_location_list
            WHERE isys_catg_location_list__isys_obj__id ' . $this->prepare_in_condition($ids) . ';';

        $result = $this->retrieve($sql);

        while ($row = $result->get_row($result)) {
            if (empty($row['id']) || empty($row['parent'])) {
                continue;
            }

            if (!isset($parents[$row['id']])) {
                $parents[$row['id']] = ['parents' => []];
            }

            $parents[$row['id']]['parents'][] = $row['parent'];

            $found[] = $row['parent'];
        }

        $this->findParents($found, $parents);
    }
}
