[{isys_group name="tom.popup.floorplan"}]
<div id="floorplan-layout-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__HEADER"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <div id="floorplan-layout-popup-functions" class="p5 border-bottom">
            <div class="input-group input-size-small">
                [{isys type="f_dialog" name="floorplan-layout-selection"}]

                <div class="input-group-addon input-group-addon-clickable" data-action="remove-selfdefined" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__REMOVE_BUTTON_TITLE"}]" data-tooltip="1">
                    <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" />
                </div>
            </div>

            <div class="fr">
                <div class="input-group input-size-small">
                    [{isys type="f_text" name="floorplan-layout-popup-selfdefined-title"}]

                    <div class="input-group-addon input-group-addon-clickable" data-action="save-selfdefined" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__SAVE_BUTTON_TITLE"}]" data-tooltip="1">
                        <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" />
                    </div>
                </div>
            </div>

            <br class="cb" />
        </div>
        <div id="floorplan-layout-popup-canvas">
            <svg>
                <defs>
                    <pattern id="inner-grid" width="10" height="10" patternUnits="userSpaceOnUse">
                        <rect width="100%" height="100%" fill="none" stroke="#ccc" stroke-width="0.5" />
                    </pattern>
                    <pattern id="grid" width="100" height="100" patternUnits="userSpaceOnUse">
                        <rect width="100%" height="100%" fill="url(#inner-grid)" stroke="#ccc" stroke-width="1.5" />
                    </pattern>
                </defs>
                <rect class="grid" x="0" y="0" width="100%" height="100%" fill="url(#grid)"></rect>
                <g id="canvas">
                    <polygon id="layout" class="object" points="-100,-100 100,-100 100,100 -100,100"></polygon>
                    <circle class="zero" r="5"></circle>
                    <g id="forms"></g>
                    <circle class="adder" r="5" />
                    <g class="controls"></g>
                    <g class="extra"></g>
                </g>
                <g class="scale" transform="translate(10, 10)"></g>
            </svg>
        </div>
        <div id="floorplan-layout-popup-sidebar" class="border-left">
            <ul id="floorplan-layout-popup-sidebar-tabs" class="browser-tabs tree-tabs m0">
                <li><a href="#floorplan-layout-popup-sidebar-forms">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_FORMS"}]</a></li>
                <li><a href="#floorplan-layout-popup-sidebar-design">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN"}]</a></li>
                <li><a href="#floorplan-layout-popup-sidebar-grid">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_GRID"}]</a></li>
            </ul>

            <div id="floorplan-layout-popup-sidebar-forms" class="p5">
                <ul class="list-style-none m0">
                    <li class="p5">
                        <div class="form-preview" data-type="square" data-options='{"size":16}' data-transform='{"x":12, "y":12}'></div>
                        <span class="ml5">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__SQUARE"}]</span>
                        <button type="button" class="btn ml-auto" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__FORM_ADD" p_bHtmlEncode=false}]">
                            <img src="[{$dir_images}]axialis/basic/symbol-add.svg" />
                        </button>
                    </li>
                    <li class="p5">
                        <div class="form-preview" data-type="rect" data-options='{"width":16,"height":8}' data-transform='{"x":12, "y":12}'></div>
                        <span class="ml5">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__RECTANGLE"}]</span>
                        <button type="button" class="btn ml-auto" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__FORM_ADD" p_bHtmlEncode=false}]">
                            <img src="[{$dir_images}]axialis/basic/symbol-add.svg" />
                        </button>
                    </li>
                    <li class="p5">
                        <div class="form-preview" data-type="circle" data-options='{"radius":8}' data-transform='{"x":12, "y":12}'></div>
                        <span class="ml5">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__CIRCLE"}]</span>
                        <button type="button" class="btn ml-auto" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__FORM_ADD" p_bHtmlEncode=false}]"><img src="[{$dir_images}]axialis/basic/symbol-add.svg" /></button>
                    </li>
                    <li class="p5">
                        <div class="form-preview" data-type="door-left" data-options='{"size":16}' data-transform='{"x":4, "y":4}'></div>
                        <span class="ml5">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR"}] ([{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR__OPENES_LEFT"}])</span>
                        <button type="button" class="btn ml-auto" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__FORM_ADD" p_bHtmlEncode=false}]">
                            <img src="[{$dir_images}]axialis/basic/symbol-add.svg" />
                        </button>
                    </li>
                    <li class="p5">
                        <div class="form-preview" data-type="door-right" data-options='{"size":16}' data-transform='{"x":4, "y":4}'></div>
                        <span class="ml5">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR"}] ([{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__DOOR__OPENES_RIGHT"}])</span>
                        <button type="button" class="btn ml-auto" title="[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__FORM_ADD" p_bHtmlEncode=false}]">
                            <img src="[{$dir_images}]axialis/basic/symbol-add.svg" />
                        </button>
                    </li>
                </ul>
            </div>
            <div id="floorplan-layout-popup-sidebar-design" class="p5">
                <table class="contentTable w100">
                    <tr>
                        <td style="width: 30%"></td>
                        <td class="value">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__COLORS"}]</td>
                    </tr>
                    <tr>
                        <td class="key pr20">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__BACKGROUND"}]</td>
                        <td>
                            <div class="two-col">[{isys type="f_dialog" name="design-background-transparency"}]</div>
                            <div class="two-col pl20">[{isys type="f_colorpicker" name="design-background-color"}]</div>
                        </td>
                    </tr>
                    <tr>
                        <td class="key pr20">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__BORDER"}]</td>
                        <td>
                            <div class="two-col">[{isys type="f_dialog" name="design-border-size"}]</div>
                            <div class="two-col pl20">[{isys type="f_colorpicker" name="design-border-color"}]</div>
                        </td>
                    </tr>
                    <tr>
                        <td></td>
                        <td class="value pt20">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__SELECTION"}]</td>
                    </tr>
                    <tr>
                        <td class="key pr20"><label for="design-selection-x">X (cm)</label></td>
                        <td>[{isys type="f_text" name="design-selection-x"}]</td>
                    </tr>
                    <tr>
                        <td class="key pr20"><label for="design-selection-y">Y (cm)</label></td>
                        <td>[{isys type="f_text" name="design-selection-y"}]</td>
                    </tr>
                    <tr>
                        <td class="key pr20 pb15"><label for="design-selection-rotation">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__ROTATION"}]</label></td>
                        <td class="pb15">[{isys type="f_text" name="design-selection-rotation"}]</td>
                    </tr>

                    <!-- Some 'specific' forms (size, radius, width/height) will be added here -->
                </table>
            </div>
            <div id="floorplan-layout-popup-sidebar-grid" class="p5">
                <table class="contentTable w100">
                    <tr>
                        <td class="key pr20" style="width: 30%"><label for="grid-snap-to-grid">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__GRID__SNAP"}]</label></td>
                        <td><input type="checkbox" id="grid-snap-to-grid" checked></td>
                    </tr>
                </table>
            </div>
        </div>
    </div>

    <div class="popup-footer-ng">
        <button type="button" class="btn mr5" id="floorplan-layout-popup-save">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>

        <button type="button" class="btn ml-auto" id="floorplan-layout-popup-remove">
            <img src="[{$dir_images}]icons/silk/delete.png" /><span>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__REMOVE_FROM_FLOORPLAN_BUTTON"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        var $popup                   = $('floorplan-layout-popup'),
            $canvas                  = $('floorplan-layout-popup-canvas'),
            $sideBar                 = $('floorplan-layout-popup-sidebar'),
            $functionsBar            = $('floorplan-layout-popup-functions'),
            $layoutSelection         = $('floorplan-layout-selection'),
            $selfdefinedName         = $('floorplan-layout-popup-selfdefined-title'),
            $selfdefinedSaveButton   = $functionsBar.down('[data-action="save-selfdefined"]'),
            $selfdefinedRemoveButton = $functionsBar.down('[data-action="remove-selfdefined"]'),
            $accept_button           = $('floorplan-layout-popup-save'),
            $remove_button           = $('floorplan-layout-popup-remove'),
            preselectedLayout        = JSON.parse('[{$preselectedLayout|json_encode|escape:"javascript"}]'),
            layouts                  = JSON.parse('[{$layouts|json_encode|escape:"javascript"}]'),
            layoutSidebar,
            layoutEditor;

        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__WIDTH', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__WIDTH" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__HEIGHT', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__HEIGHT" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__SIZE', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__SIZE" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__RADIUS', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__RADIUS" p_bHtmlEncode=false}]');
        idoit.Translate.set('LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__ROTATION', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TAB_DESIGN__OPTION__ROTATION" p_bHtmlEncode=false}]');

        // Prevent sending the form via ENTER.
        $popup.on('keydown', 'input,select', function (ev) {
            if (ev.key === 'Enter') {
                ev.findElement('input,select').simulate('change');

                ev.preventDefault();
            }
        });

        const requirements = {
            'floorplan.layout-editor': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-layout-editor.js',
            'floorplan.layout-editor.drag-move': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-layout-editor-drag-move.js',
            'floorplan.layout-sidebar': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-layout-sidebar.js',
            'floorplan.helper': '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-helper.js'
        }

        for (const key in requirements) {
            if (requirements.hasOwnProperty(key)) {
                idoit.Require.addModule(key, requirements[key]);
            }
        }

        idoit.Require.require(Object.keys(requirements), function () {
            const currentLayout = window.getLayout();

            $popup.select('.popup-closer').invoke('on', 'click', function () {
                popup_close();
            });

            $canvas.on('init:layoutEditor', function () {

                if (currentLayout.layout !== null) {
                    layoutEditor
                        .setLayout(currentLayout.layout)
                        .setForms(currentLayout.forms);
                } else {
                    layoutEditor
                        .setLayout(preselectedLayout)
                        .setForms([]);
                }

                layoutEditor
                    .process()
                    .zoomTo(layoutEditor.width / 2, layoutEditor.height / 2, 1);
            });

            if ($layoutSelection && $selfdefinedSaveButton && $selfdefinedRemoveButton) {
                $layoutSelection.on('change', function () {
                    if (!layoutEditor) {
                        return;
                    }

                    const selection = layouts[$layoutSelection.getValue()] || {layout: preselectedLayout, forms: []};

                    // First we re-set it to remove all accessed data.
                    layoutEditor
                        .setLayout(preselectedLayout)
                        .setForms([])
                        .process()
                        .setLayout(selection.layout)
                        .setForms(selection.forms)
                        .process();

                    // Set the 'layout name' field.
                    $selfdefinedName.writeAttribute('placeholder', $layoutSelection.getValue() > 4
                        ? '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__TO_OVERWRITE_LEAVE_EMPTY" p_bHtmlEncode=false}]'
                        : '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__FORM_NAME" p_bHtmlEncode=false}]');
                });

                $layoutSelection.on('update:polygonSelection', function (ev) {
                    var i, val = $layoutSelection.getValue();

                    if (ev.memo.value) {
                        val = ev.memo.value;
                    }

                    $layoutSelection
                        .update(new Element('option', {value: 0}).update('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__NEW_FORM"}]'));

                    for (i in layouts) {
                        if (layouts.hasOwnProperty(i)) {
                            $layoutSelection.insert(new Element('option', {value: i}).update(layouts[i].title))
                        }
                    }

                    $layoutSelection.setValue(val).simulate('change');

                    $selfdefinedName.writeAttribute('placeholder', '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__FORM_NAME" p_bHtmlEncode=false}]');
                });

                $selfdefinedSaveButton.on('click', function () {
                    if ($layoutSelection.getValue() == 0 && $selfdefinedName.getValue().blank()) {
                        idoit.Notify.info('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__FORM_NAME_REMINDER"}]');
                        return;
                    }

                    if ($layoutSelection.getValue() > 0 && $layoutSelection.getValue() <= 4) {
                        $layoutSelection.addClassName('input-error');

                        setTimeout(function () {
                            $layoutSelection.removeClassName('input-error');
                        }, 2500);

                        idoit.Notify.error('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__OVERWRITE_FAILURE"}]', {life: 5});
                        return;
                    }

                    if ($layoutSelection.getValue() > 4 && $selfdefinedName.getValue().blank() && !confirm('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__OVERWRITE_CONFIRM" p_bHtmlEncode=false}]')) {
                        return;
                    }

                    $selfdefinedSaveButton.down('img').addClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/user-interface/loading.svg');

                    new Ajax.Request('[{$ajax_url}]', {
                        parameters: {
                            action:   'saveLayout',
                            layoutId: $layoutSelection.getValue(),
                            name:     $selfdefinedName.getValue(),
                            layout:   JSON.stringify(layoutEditor.getLayoutData()),
                            forms:    JSON.stringify(layoutEditor.getFormData())
                        },
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            $selfdefinedSaveButton.down('img').removeClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/basic/symbol-ok.svg');

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (json.success) {
                                $selfdefinedName.setValue('');

                                if ($layoutSelection.getValue() > 4) {
                                    idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__OVERWRITTEN"}]');
                                } else {
                                    idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__SAVED"}]');
                                }

                                layouts = json.data.layouts

                                $layoutSelection.fire('update:polygonSelection', {value: json.data.newId});
                            } else {
                                idoit.Notify.error(json.message, {sticky: true});
                            }
                        }
                    });
                });

                $selfdefinedRemoveButton.on('click', function () {
                    if ($layoutSelection.getValue() == 0) {
                        idoit.Notify.error('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__REMOVE_FAILURE"}]', {life: 5});
                        return;
                    }

                    if (!confirm('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_LAYOUT__REMOVE_BUTTON_CONFIRM" p_bHtmlEncode=false}]')) {
                        return;
                    }

                    new Ajax.Request('[{$ajax_url}]', {
                        parameters: {
                            action:   'deleteLayout',
                            layoutId: $layoutSelection.getValue()
                        },
                        onComplete: function (response) {
                            var json = response.responseJSON;

                            if (!is_json_response(response, true)) {
                                return;
                            }

                            if (json.success && json.data.deleted) {
                                idoit.Notify.success('[{isys type="lang" ident="LC__MODULE__FLOORPLAN__DELETED"}]');

                                layouts = json.data.layouts;

                                $layoutSelection.fire('update:polygonSelection', {value: 0});
                            } else {
                                idoit.Notify.error(json.message, {sticky: true});
                            }
                        }
                    });
                });

                $layoutSelection.fire('update:polygonSelection', {value: 0});
            }

            layoutSidebar = new LayoutSidebar($sideBar, {
                $canvas: $canvas
            });

            layoutEditor = new LayoutEditor($canvas, {
                $sideBar:              $sideBar,
                maxPointsNotification: '[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_EDITOR__MAX_POINTS_SET"}]',
            });

            $accept_button.on('click', function () {
                window.setLayout(layoutEditor.getLayoutData(), layoutEditor.getFormData());

                popup_close();
            });

            $remove_button.on('click', function () {
                window.setLayout(null, []);

                popup_close();
            });

            document.on('keydown', function (ev) {
                ev = ev || window.event;

                if (ev.keyCode == Event.KEY_DELETE && !ev.findElement('input')) {
                    layoutEditor.removeSelection();
                }
            });

            $canvas.fire('init:layoutEditor');
        });
    })();
</script>
<style>
    #floorplan-layout-popup {
        box-sizing: border-box;
        position: relative;
        height: 100%;
    }

    #floorplan-layout-popup-canvas {
        position: absolute;
        top: 43px;
        right: 400px;
        bottom: 0;
        left: 0;
        background: #eee;
        overflow: hidden;
    }

    #floorplan-layout-popup-sidebar {
        position: absolute;
        width: 400px;
        top: 42px;
        right: 0;
        bottom: 0;
        left: auto;
        background: #fff;
    }

    #floorplan-layout-popup-sidebar .two-col {
        float: left;
        width: 50%;
    }

    #floorplan-layout-popup-sidebar table {
        table-layout: fixed;
    }

    #floorplan-layout-popup-sidebar-forms li {
        position: relative;
        height: 42px;
        display: flex;
        align-items: center;
    }

    #floorplan-layout-popup-sidebar-forms li:hover {
        background: #eee;
    }

    #floorplan-layout-popup-sidebar-forms li .form-preview {
        width: 24px;
        height: 24px;
    }

    #floorplan-layout-popup-canvas text {
        fill: #000;
        stroke: none;
        user-select: none;
        -ms-user-select: none;
        -webkit-user-select: none;
        -moz-user-select: none;
    }

    #floorplan-layout-popup-canvas circle.adder {
        stroke: #888;
        stroke-width: 2px;
        fill: transparent;
        cursor: pointer;
    }

    #floorplan-layout-popup-canvas circle.zero {
        stroke: none;
        fill: #f00;
    }

    #floorplan-layout-popup-canvas .controls circle {
        stroke-width: 3px;
        stroke: #888;
        fill: transparent;
        cursor: pointer;
    }

    #floorplan-layout-popup-canvas .controls circle:hover,
    #floorplan-layout-popup-canvas .controls circle.selected {
        stroke: #5897fb;
    }

    #floorplan-layout-popup-canvas .object {
        stroke: #000;
        stroke-width: 1px;
        fill-opacity: 0.75;
        cursor: pointer;
    }

    #floorplan-layout-popup-canvas .object.selected,
    #floorplan-layout-popup-canvas .object .selected {
        stroke: #fff;
        stroke-width: 3px;
        stroke-dasharray: 3, 3;
        cursor: move;
    }

    #floorplan-layout-popup-canvas path {
        stroke: #888;
        fill: none;
    }

    #floorplan-layout-popup-canvas .scale path {
        stroke: #000;
    }
</style>
[{/isys_group}]
