[{isys_group name="tom.popup.floorplan"}]
<div id="floorplan-object-radius-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_RADIUS__HEADER"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <div id="floorplan-object-radius-popup-functions" class="p5 border-bottom display-flex align-items-center">
            <label class="fl" for="floorplan-object-radius-radius">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_RADIUS__RADIUS"}]</label>
            <div class="input-group ml10">
                [{isys type="f_count" name="floorplan-object-radius-radius"}]
            </div>

            <div class="input-group ml5 mr20">
                [{isys type="f_dialog" name="floorplan-object-radius-unit"}]
            </div>

            <label class="fl" for="floorplan-object-radius-color">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_RADIUS__COLOR"}]</label>
            <div class="mr20">
                [{isys type="f_colorpicker" name="floorplan-object-radius-color"}]
            </div>

            <label class="fl" for="floorplan-object-radius-opacity">[{isys type="lang" ident="LC__MODULE__FLOORPLAN__POPUP_RADIUS__TRANSPARENCY"}]</label>
            <div class="input-group input-size-mini ml10">
                [{isys type="f_dialog" name="floorplan-object-radius-opacity"}]
            </div>

            <br class="cb" />
        </div>
        <div id="floorplan-object-radius-popup-canvas"></div>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn mr5" id="floorplan-popup-save">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ACCEPT"}]</span>
        </button>

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>
    </div>
</div>

<script type="text/javascript">
    (function () {
        'use strict';

        var $popup         = $('floorplan-object-radius-popup'),
            $canvas        = $('floorplan-object-radius-popup-canvas'),
            $accept_button = $('floorplan-popup-save'),
            objectRadius,
            $radiusRadius  = $('floorplan-object-radius-radius'),
            $radiusUnit    = $('floorplan-object-radius-unit'),
            $radiusColor   = $('floorplan-object-radius-color'),
            $radiusOpacity = $('floorplan-object-radius-opacity');

        idoit.Require.addModule('floorplan.object-radius', '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-object-radius.js');

        idoit.Require.require(['floorplan.object-radius'], function () {
            objectRadius = new ObjectRadius($canvas, {
                polygon:         JSON.parse('[{$objectPolygon|json_encode|escape:"javascript"}]'),
                objectTypeColor: '[{$objectTypeColor}]',
                displayRadius:   $radiusRadius.getValue() !== '0',
                radiusColor:     $radiusColor.getValue(),
                radiusOpacity:   $radiusOpacity.getValue()
            });

            $radiusRadius.on('change', function () {
                objectRadius.displayRadius($radiusRadius.getValue() !== '0')
            });

            $radiusColor.on('change', function () {
                objectRadius.setColor($radiusColor.getValue());
            });

            $radiusOpacity.on('change', function () {
                objectRadius.setOpacity($radiusOpacity.getValue());
            });

            $popup.select('.popup-closer').invoke('on', 'click', function () {
                popup_close();
            });

            $accept_button.on('click', function () {
                // This function can be found in "visualization_gui.js".
                window.setObjectRadius($radiusRadius.getValue(), $radiusUnit.getValue(), $radiusColor.getValue(), $radiusOpacity.getValue());

                popup_close();
            });
        });
    })();
</script>
<style>
    #floorplan-object-radius-popup-canvas {
        position: absolute;
        top: 43px;
        right: 0;
        bottom: 0;
        left: 0;
        background: #eee url('[{$dir_images}]10x10-grid.gif') repeat scroll -51px -2px;
    }

    #floorplan-object-radius-popup-canvas circle {
        stroke: none;
    }

    #floorplan-object-radius-popup-canvas polygon {
        stroke: #000;
        stroke-width: 2px;
    }

</style>
[{/isys_group}]
