[{isys_group name="tom.popup.floorplan"}]
<div id="floorplan-profile-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__FLOORPLAN_PROFILE"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <button type="button" id="C__FLOORPLAN_PROFILE__NEW_PROFILE" class="btn m5" [{if !$create_right}]disabled="disabled"[{/if}]>
            <img src="[{$dir_images}]axialis/basic/symbol-add.svg" /><span>[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__NEW_PROFILE"}]</span>
        </button>

        <ul id="floorplan-profile-list" class="border-top m0 p0 list-style-none">
            <!-- To be filled by JS -->
        </ul>

        <div id="floorplan-profile-configuration" class="hide">
            <table class="contentTable">
                <tr>
                    <td class="key">[{isys type="f_label" name="C__FLOORPLAN_PROFILE__TITLE" ident="LC__FLOORPLAN_PROFILE__TITLE"}]</td>
                    <td class="value">[{isys type="f_text" name="C__FLOORPLAN_PROFILE__TITLE"}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type="f_label" name="C__FLOORPLAN_PROFILE__CHANGE_TAB_ON_OBJ_SELECT" ident="LC__FLOORPLAN_PROFILE__CHANGE_TAB_ON_OBJ_SELECT"}]</td>
                    <td class="value">[{isys type="f_dialog" name="C__FLOORPLAN_PROFILE__CHANGE_TAB_ON_OBJ_SELECT"}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type="f_label" name="C__FLOORPLAN_PROFILE__DBL_CLICK_TO_OPEN_OBJECT" ident="LC__FLOORPLAN_PROFILE__DBL_CLICK_TO_OPEN_OBJECT"}]</td>
                    <td class="value">[{isys type="f_dialog" name="C__FLOORPLAN_PROFILE__DBL_CLICK_TO_OPEN_OBJECT"}]</td>
                </tr>
            </table>

            <div id="floorplan-profile-tab-container">
                <ul id="floorplan-popup-tabs" class="browser-tabs m0 bg-neutral-200 border-top">
                    <li><a href="#floorplan-popup-tab-a">[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__TAB__VISUALIZATION_OPTIONS"}]</a></li>
                    <li><a href="#floorplan-popup-tab-b">[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__TAB__DEFAULTS"}]</a></li>
                    <li><a href="#floorplan-popup-tab-c">[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__TAB__OBJECT_INFORMATION"}]</a></li>
                    [{if $admin_right}]
                        <li><a href="#floorplan-popup-tab-d">[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__TAB__OVERWRITE_SETTINGS"}]</a></li>
                    [{/if}]
                </ul>
                <div id="floorplan-popup-tab-a">

                    <!-- Visualisierungsoptionen -->

                    <table class="contentTable pt10">
                        <tr>
                            <td class="key pb10">[{isys type="f_label" name="C__FLOORPLAN_PROFILE__HIGHLIGHT_COLOR" ident="LC__FLOORPLAN_PROFILE__HIGHLIGHT_COLOR"}]</td>
                            <td class="value pb10">[{isys type="f_colorpicker" name="C__FLOORPLAN_PROFILE__HIGHLIGHT_COLOR"}]</td>
                        </tr>
                        <tr>
                            <td class="key pb10">[{isys type="f_label" name="C__FLOORPLAN_PROFILE__DISPLAY_RADIUS" ident="LC__FLOORPLAN_PROFILE__DISPLAY_RADIUS"}]</td>
                            <td class="value pb10">[{isys type="f_dialog" name="C__FLOORPLAN_PROFILE__DISPLAY_RADIUS"}]</td>
                        </tr>
                    </table>
                </div>
                <div id="floorplan-popup-tab-b">

                    <!-- Standardwerte -->

                    <table class="contentTable pt10">
                        <tr>
                            <td class="key">[{isys type="f_label" name="C__FLOORPLAN_PROFILE__DEFAULT_OBJECT_TYPE_FILTER" ident="LC__FLOORPLAN_PROFILE__DEFAULT_OBJECT_TYPE_FILTER"}]</td>
                            <td class="value">[{isys type="f_dialog" name="C__FLOORPLAN_PROFILE__DEFAULT_OBJECT_TYPE_FILTER"}]</td>
                        </tr>
                    </table>
                </div>
                <div id="floorplan-popup-tab-c">

                    <!-- Objektinformationen -->

                    <div id="floorplan-popup-form-property-selector" class="ml5 pt10"></div>
                </div>
                <div id="floorplan-popup-tab-d">

                    <!-- Optionen um die Konfiguration anderer Benutzer zu überschreiben -->

                    <table class="contentTable pt10">
                        <tr>
                            <td class="key">
                                [{isys type="lang" ident="LC__VISUALIZATION_PROFILES__TAB__SET_AS_GLOBAL_DEFAULT"}]
                            </td>
                            <td class="value pl20">
                                <button type="button" class="btn" id="floorplan-popup-overwrite-global-default">
                                    <img src="[{$dir_images}]axialis/basic/star.svg" />
                                    <span>[{isys type="lang" ident="LC__VISUALIZATION_PROFILES__SET_DEFAULT_PROFILE"}]</span>
                                </button>
                                <p class="text-blue mt5">
                                    <img src="[{$dir_images}]axialis/basic/button-info.svg" class="mr5 vam" /> [{isys type="lang" ident="LC__VISUALIZATION_PROFILES__TAB__SET_AS_GLOBAL_DEFAULT_DESCRIPTION"}]
                                </p>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <hr class="mt5 mb5" />
                            </td>
                        </tr>
                        <tr>
                            <td class="key">
                                [{isys type="lang" ident="LC__VISUALIZATION_PROFILES__TAB__OVERWRITE_DEFAULT_PROFILE"}]
                            </td>
                            <td class="value">
                                [{isys type="f_popup"
                                    p_strPopupType="browser_object_ng"
                                    name="C_OVERWRITE_OBJECT_SELECTION"
                                    title="LC__BROWSER__TITLE__CONTACT"
                                    catFilter='C__CATS__PERSON'
                                    multiselection=true}]

                                <br class="cb" />

                                <button type="button" class="btn ml20 mt5" id="floorplan-popup-overwrite-user-defaults">
                                    <img src="[{$dir_images}]icons/silk/table_add.png" class="mr5" /><span>[{isys type="lang" ident="LC_UNIVERSAL__APPLY"}]</span>
                                </button>
                            </td>
                        </tr>
                    </table>

                </div>
            </div>
        </div>
    </div>

    <div class="popup-footer">
        <button type="button" class="btn mr5" data-action="save">
            <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__ACCEPT"}]</span>
        </button>

        <button type="button" class="btn" data-action="cancel">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__CLOSE"}]</span>
        </button>
    </div>
</div>
<script type="text/javascript">
    (function () {
        'use strict';

        idoit.Require.addModule('floorplan.profile', '[{isys_module_floorplan::getWwwPath()}]assets/js/floorplan-profile.js')

        idoit.Translate.set('LC__FLOORPLAN_PROFILE__DELETE_PROFILE', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__DELETE_PROFILE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__DELETE_PROFILE_CONFIRM', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__DELETE_PROFILE_CONFIRM" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__SET_DEFAULT_PROFILE', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__SET_DEFAULT_PROFILE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__SET_DEFAULT_PROFILE_FIRST_SAVE', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__SET_DEFAULT_PROFILE_FIRST_SAVE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__EDIT_PROFILE', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__EDIT_PROFILE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__DUPLICATE', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__DUPLICATE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__DUPLICATE_PROFILE', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__DUPLICATE_PROFILE" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__DUPLICATE_PROFILE_CONFIRM', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__DUPLICATE_PROFILE_CONFIRM" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__VISUALIZATION_PROFILES__CLOSE_POPUP', '[{isys type="lang" ident="LC__VISUALIZATION_PROFILES__CLOSE_POPUP" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC_UNIVERSAL__ABORT', '[{isys type="lang" ident="LC_UNIVERSAL__ABORT" p_bHtmlEncode=false}]')
        idoit.Translate.set('LC__FLOORPLAN_PROFILE__OBJECT_INFO_PARSE_ERROR', '[{isys type="lang" ident="LC__FLOORPLAN_PROFILE__OBJECT_INFO_PARSE_ERROR" p_bHtmlEncode=false}]')

        idoit.Require.require('floorplan.profile', function () {
            var $popup                            = $('floorplan-profile-popup'),
                $profileDefaultObjectTypeFilter   = $('C__FLOORPLAN_PROFILE__DEFAULT_OBJECT_TYPE_FILTER'),
                profileData                       = JSON.parse('[{$profiles|json_encode|escape:"javascript"}]'),
                profileOptions                    = {
                    $newProfileButton:                 $('C__FLOORPLAN_PROFILE__NEW_PROFILE'),
                    $profileList:                      $('floorplan-profile-list'),
                    $profileConfiguration:             $('floorplan-profile-configuration'),
                    $profileName:                      $('C__FLOORPLAN_PROFILE__TITLE'),
                    $profileDisplayRadius:             $('C__FLOORPLAN_PROFILE__DISPLAY_RADIUS'),
                    $profileChangeTabOnObjectSelect:   $('C__FLOORPLAN_PROFILE__CHANGE_TAB_ON_OBJ_SELECT'),
                    $profileDblClickToOpenObject:      $('C__FLOORPLAN_PROFILE__DBL_CLICK_TO_OPEN_OBJECT'),
                    $profileHighlightColor:            $('C__FLOORPLAN_PROFILE__HIGHLIGHT_COLOR'),
                    $profileDefaultObjectTypeFilter:   $profileDefaultObjectTypeFilter,
                    $profilePropertySelectorContainer: $('floorplan-popup-form-property-selector'),
                    $profileOverwriteGlobalDefault:    $('floorplan-popup-overwrite-global-default'),
                    $profileOverwriteUsers:            $('C_OVERWRITE_OBJECT_SELECTION__HIDDEN'),
                    $profileOverwriteUserDefaults:     $('floorplan-popup-overwrite-user-defaults'),
                    $saveButton:                       $popup.down('[data-action="save"]'),
                    $cancelButton:                     $popup.down('[data-action="cancel"]'),
                    propertySelectorProvides:          '[{$smarty.const.C__PROPERTY__PROVIDES__REPORT}]',
                    ajaxSmartyUrl:                     '[{$ajaxSmartyUrl}]',
                    primaryProfile:                    '[{$defaultProfile}]',
                    createRight:                       ('[{$create_right}]' === '1'),
                    editRight:                         ('[{$edit_right}]' === '1'),
                    deleteRight:                       ('[{$delete_right}]' === '1'),
                    supervisorRight:                   ('[{$admin_right}]' === '1')
                };

            // Prepare tabs.
            new Tabs('floorplan-profile-tab-container', {
                wrapperClass: 'browser-tabs',
                contentClass: 'result-tab-content',
                tabClass:     'mouse-pointer'
            });

            // Prepare the object-type "Chosen".
            new Chosen($profileDefaultObjectTypeFilter, {
                default_multiple_text:     '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSEN_PLACEHOLDER" p_bHtmlEncode=false}]',
                placeholder_text_multiple: '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSEN_PLACEHOLDER" p_bHtmlEncode=false}]',
                no_results_text:           '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSEN_EMPTY" p_bHtmlEncode=false}]',
                search_contains:           true,
                width:                     290
            });

            new ChosenExtension($profileDefaultObjectTypeFilter, {
                'chosen-btn-all':      '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSE_ALL_SHORT"}]',
                'chosen-btn-inverted': '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSE_INVERTED_SHORT"}]',
                'chosen-btn-none':     '[{isys type="lang" ident="LC__UNIVERSAL__CHOOSE_NONE_SHORT"}]',
                chosenMaxHeight:       '100px'
            });

            // Prepare "close popup" observer.
            $popup.select('.popup-closer').invoke('on', 'click', function () {
                popup_close('popup_commentary');
            });

            new FloorplanProfile($popup, profileOptions, profileData);
        });
    })();
</script>
<style>
    #floorplan-profile-popup {
        box-sizing: border-box;
        position: relative;
        height: 100%;
    }

    /* Overwriting "relative" image path */
    #floorplan-profile-popup .chosen-container-multi .chosen-choices li.search-choice .search-choice-close {
        background-image: url('[{isys_application::instance()->www_path}]images/chosen/chosen-sprite.png');
    }

    ul#floorplan-profile-list li {
        background: #eee;
        border-bottom: 1px solid #888;
        padding: 5px;
        vertical-align: middle;
        height: 45px;
        display: flex;
        align-items: center;
    }

    ul#floorplan-profile-list li .cmdb-marker {
        height: 20px;
    }

    ul#floorplan-profile-list li strong,
    ul#floorplan-profile-list li span {
        vertical-align: middle;
        line-height: 22px;
    }
</style>
[{/isys_group}]
