<?php

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\ActionType;
use idoit\Module\SyneticsFlows\Automation\Trigger\Condition\Condition;
use idoit\Module\SyneticsFlows\Automation\Trigger\TriggerType\TriggerType;
use idoit\Module\SyneticsFlows\Controller\AttributeController;
use idoit\Module\SyneticsFlows\Controller\AttributeDataController;
use idoit\Module\SyneticsFlows\Controller\AutomationController;
use idoit\Module\SyneticsFlows\Controller\CategoryController;
use idoit\Module\SyneticsFlows\Controller\CiObjectController;
use idoit\Module\SyneticsFlows\Controller\ExecutionController;
use idoit\Module\SyneticsFlows\Controller\IndexController;
use idoit\Module\SyneticsFlows\Controller\ObjectTypeController;
use idoit\Module\SyneticsFlows\Controller\TemplateController;
use idoit\Module\SyneticsFlows\Controller\TriggerController;
use idoit\Module\SyneticsFlows\Dto\Criteria;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    $routes->add('synetics_flows.automation.invoke', '/api/flows/automation/invoke/{objectId}/{automationId}')
        ->methods(['GET', 'POST'])
        ->controller([TriggerController::class, 'invoke']);

    $routes->add('synetics_flows.automation.trigger.validate', '/api/flows/automation/trigger/validate')
        ->methods(['PUT'])
        ->defaults([
            '_class' => TriggerType::class
        ])
        ->controller([AutomationController::class, 'validate']);
    $routes->add('synetics_flows.automation.action.validate', '/api/flows/automation/action/validate')
        ->methods(['PUT'])
        ->defaults([
            '_class' => ActionType::class
        ])
        ->controller([AutomationController::class, 'validate']);
    $routes->add('synetics_flows.automation.condition.validate', '/api/flows/automation/condition/validate')
        ->methods(['PUT'])
        ->defaults([
            '_class' => Condition::class
        ])
        ->controller([AutomationController::class, 'validate']);

    $routes->add('synetics_flows.automation.criteria.validate', '/api/flows/automation/criteria/validate')
        ->methods(['PUT'])
        ->defaults([
            '_class' => Criteria::class
        ])
        ->controller([AutomationController::class, 'validate']);

    $routes->add('synetics_flows.automation.execution.find', '/api/flows/execution')
        ->methods(['GET'])
        ->controller([ExecutionController::class, 'find']);

    $routes->add('synetics_flows.automation.execution.get', '/api/flows/execution/{id}')
        ->methods(['GET'])
        ->controller([ExecutionController::class, 'get']);

    $routes->add('synetics_flows.automation.execution.perform', '/api/flows/execution/{id}')
        ->methods(['PUT'])
        ->controller([ExecutionController::class, 'perform']);

    $routes->add('synetics_flows.automation.automation.find', '/api/flows/automation')
        ->methods(['GET'])
        ->controller([AutomationController::class, 'find']);

    $routes->add('synetics_flows.automation.automation.get', '/api/flows/automation/{id}')
        ->methods(['GET'])
        ->controller([AutomationController::class, 'get']);

    $routes->add('synetics_flows.automation.automation.create', '/api/flows/automation')
        ->methods(['POST'])
        ->controller([AutomationController::class, 'create']);

    $routes->add('synetics_flows.automation.automation.update', '/api/flows/automation/{id}')
        ->methods(['PUT'])
        ->controller([AutomationController::class, 'update']);

    $routes->add('synetics_flows.automation.automation.delete', '/api/flows/automation/{id}/delete')
        ->methods(['PUT'])
        ->controller([AutomationController::class, 'remove']);

    $routes->add('synetics_flows.automation.automation.export', '/api/flows/automation/export')
        ->methods(['POST'])
        ->controller([AutomationController::class, 'export']);

    // Index page.
    $routes->add('synetics_flows.frame-index', '/flows/iframe')
        ->methods(['GET'])
        ->controller([IndexController::class, 'iframe']);

    $routes->add('synetics_flows.frame-index-with-slug', '/flows/iframe/{slug}')
        ->methods(['GET'])
        ->requirements(['slug' => '.*'])
        ->controller([IndexController::class, 'iframe']);

    $routes->add('synetics_flows.template.preview', '/api/flows/template/preview')
        ->methods(['POST'])
        ->controller([TemplateController::class, 'preview']);

    $routes->add('synetics_flows.template.validate', '/api/flows/template/validate')
        ->methods(['POST'])
        ->controller([TemplateController::class, 'validate']);

    // Index page.
    $routes->add('synetics_flows.index', '/flows')
        ->methods(['GET'])
        ->controller([IndexController::class, 'page']);

    $routes->add('synetics_flows.index-with-slug', '/flows/{slug}')
        ->methods(['GET'])
        ->requirements(['slug' => '.*'])
        ->controller([IndexController::class, 'page']);

    $routes->add('synetics_flows.api.object-type.find', '/api/flows/object-type')
        ->methods(['GET'])
        ->controller([ObjectTypeController::class, 'find']);

    $routes->add('synetics_flows.api.object-type.get', '/api/flows/object-type/{id}')
        ->methods(['GET'])
        ->controller([ObjectTypeController::class, 'get']);

    $routes->add('synetics_flows.api.category.find', '/api/flows/category')
        ->methods(['GET'])
        ->controller([CategoryController::class, 'find']);

    $routes->add('synetics_flows.api.category.get', '/api/flows/category/{id}')
        ->methods(['GET'])
        ->controller([CategoryController::class, 'get']);

    $routes->add('synetics_flows.api.attribute.find', '/api/flows/attribute')
        ->methods(['GET'])
        ->controller([AttributeController::class, 'find']);

    $routes->add('synetics_flows.api.attribute.get', '/api/flows/attribute/{id}')
        ->methods(['GET'])
        ->controller([AttributeController::class, 'get']);

    $routes->add('synetics_flows.api.object.find', '/api/flows/object')
        ->methods(['POST'])
        ->controller([CiObjectController::class, 'find']);

    $routes->add('synetics_flows.api.object.get', '/api/flows/object/{id}')
        ->methods(['GET'])
        ->controller([CiObjectController::class, 'get']);

    $routes->add('synetics_flows.api.attribute-data.find', '/api/flows/attribute/{id}/data')
        ->methods(['GET'])
        ->controller([AttributeDataController::class, 'find']);

    $routes->add('synetics_flows.api.attribute-data.get', '/api/flows/attribute/{id}/data/{entryId}')
        ->methods(['GET'])
        ->requirements(['entryId' => '\d*'])
        ->controller([AttributeDataController::class, 'get']);
};
