<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType;

use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class SendEmailAction extends ActionType
{
    public function __construct(
        #[Required]
        private ?string $subject = null,
        #[Required]
        private ?array $recipientsList = null,
        private ?string $body = null,
    )
    {
    }

    public function getSubject(): ?string
    {
        return $this->subject;
    }

    public function getRecipientsList(): array
    {
        return $this->recipientsList;
    }

    public function getBody(): ?string
    {
        return $this->body;
    }

    #[ValidationCallback]
    public function validate(array $path): array
    {
        $results = [];

        if ($this->recipientsList) {
            foreach ($this->recipientsList as $index => $email) {
                if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                    $results[] = new ValidationMessage([...$path, 'recipientsList', "$index"], 'LC__MODULE__SYNETICS_FLOWS__INVALID_EMAIL');
                }
            }
        }
        return $results;
    }


}
