<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionResult;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    'error' => ErrorExecutionResult::class,
    'object-created' => ObjectCreatedResult::class,
    'debug' => DebugResult::class,
    'api-success' => SuccessApiCallResult::class,
    'api-error' => ErrorApiCallResult::class,
    'send-email' => SendEmailResult::class,
    'object-updated' => UpdateDataResult::class,
    'validation-error' => ValidationErrorResult::class,
])]
abstract class ExecutionResult implements JsonSerializable
{
    use SerializableTrait;

    public abstract function __toString(): string;
}
