<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Condition;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    'and' => AndCondition::class,
    'or' => OrCondition::class,
    'time' => TimeCondition::class,
    'user' => UserCondition::class,
    'cmdb' => CmdbCondition::class,
])]
class Condition implements JsonSerializable
{
    use SerializableTrait;
}