<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\Invocation;

class ObjectRecycledInvocation extends Invocation
{
    public const TYPE = 'object-recycled';

    public function __construct(private int $status, ObjectContext $context)
    {
        $this->context = $context;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function __toString(): string
    {
        return 'Object is recycled';
    }
}