<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Trigger\InvocationMatcher;

use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\Invocation;
use idoit\Module\SyneticsFlows\Automation\Trigger\Invocation\ObjectRankedInvocation;

class ObjectRankedMatcher extends DaoMatcher
{
    private const STATUSES_MAP = [
        C__RECORD_STATUS__ARCHIVED => 'archived',
        C__RECORD_STATUS__DELETED => 'deleted',
    ];

    public function supports(Invocation $invocation): bool
    {
        return $invocation instanceof ObjectRankedInvocation && isset(self::STATUSES_MAP[$invocation->getStatus()]);
    }

    protected function getExtraConditions(Invocation $invocation): array
    {
        if (!$invocation instanceof ObjectRankedInvocation || !isset(self::STATUSES_MAP[$invocation->getStatus()])) {
            return [];
        }

        $status = self::STATUSES_MAP[$invocation->getStatus()];

        return [
            "JSON_EXTRACT(automation_trigger, \"$.type\") = 'object'",
            "JSON_EXTRACT(automation_trigger, \"$.objectEvent\") = '$status'",
        ];
    }
}
