<?php

namespace idoit\Module\SyneticsFlows\Controller;

use idoit\Response\IdoitResponse;
use isys_application;
use isys_auth;
use isys_module_synetics_flows;
use Symfony\Component\HttpFoundation\Response;

/**
 * Index controller
 *
 * @package   idoit\Module\synetics_flows\Processor
 * @copyright synetics
 * @license   https://www.i-doit.com/
 */
class IndexController
{
    public function page(string $slug = ''): Response
    {
        $container = isys_application::instance()->container;
        $template = $container->get('template');

        if (!isys_module_synetics_flows::isLicensed()) {
            $template
                ->assign('flowsDocumentRoot', isys_application::instance()->www_path)
                ->assign('errorMessage', $container->get('language')->get('LC__MODULE__SYNETICS_FLOWS__NOT_LICENSED'));
            return (new IdoitResponse(isys_module_synetics_flows::getPath() . 'templates/error.tpl'))->showBreadcrumb(false)->showNavbar(false);
        }

        // Assign some necessary data.
        $template->assign('jsDirectory', isys_module_synetics_flows::getWwwPath() . 'js/');
        $template->assign('slug', $slug);
        $template->assign('title', 'Flows');
        return (new IdoitResponse(isys_module_synetics_flows::getPath() . 'templates/iframe.tpl'))->showBreadcrumb(false)->showNavbar(false);
    }

    public function iframe(): Response
    {
        $container = isys_application::instance()->container;
        $template = $container->get('template');

        if (!isys_module_synetics_flows::isLicensed()) {
            $template
                ->assign('flowsDocumentRoot', isys_application::instance()->www_path)
                ->assign('errorMessage', $container->get('language')->get('LC__MODULE__SYNETICS_FLOWS__NOT_LICENSED'));
            return new Response($template->fetch(isys_module_synetics_flows::getPath() . 'templates/error.tpl'));
        }

        $auth = isys_module_synetics_flows::getAuth();
        $language = isys_application::instance()->container->get('language');

        if (!$auth->is_allowed_to(isys_auth::VIEW, 'manage-flows')) {
            $template
                ->assign(
                    'errorMessage',
                    $language->get(
                        'LC__MODULE__SYNETICS_FLOWS__AUTH__MISSING_SYNETICS_FLOWS_RIGHT',
                        $language->get('LC__AUTH__RIGHT_VIEW')
                    )
                );
            return new Response($template->fetch(isys_module_synetics_flows::getPath() . 'templates/error.tpl'));
        }
        if (!isys_module_synetics_flows::isLicensed()) {
            $template
                ->assign('errorMessage', $language->get('LC__MODULE__SYNETICS_FLOWS__NOT_LICENSED'));
            return new Response($template->fetch(isys_module_synetics_flows::getPath() . 'templates/error.tpl'));
        }

        // Assign some necessary data.
        $template
            ->assign('jsDirectory', isys_module_synetics_flows::getWwwPath() . 'js/')
            ->assign('trial', [
                'isTrial' => isys_module_synetics_flows::isTrial(),
                'daysLeft' => 30 - isys_module_synetics_flows::getTrialUsageInDays()
            ])
            ->assign('flowsAuth', [
                'create'  => $auth->is_allowed_to(isys_auth::CREATE, 'manage-flows'),
                'view'    => $auth->is_allowed_to(isys_auth::VIEW, 'manage-flows'),
                'edit'    => $auth->is_allowed_to(isys_auth::EDIT, 'manage-flows'),
                'delete'  => $auth->is_allowed_to(isys_auth::DELETE, 'manage-flows'),
                'execute' => $auth->is_allowed_to(isys_auth::EXECUTE, 'manage-flows'),
            ]);
        return new Response($template->fetch(isys_module_synetics_flows::getPath() . 'templates/index.tpl'));
    }
}
