<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class Attribute implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        private string $categoryId,
        private string $title,
        private string $type,
        private bool $isSystemRequired,
        private ?ParentAttribute $parent,
        private array $children
    )
    {
    }

    public function getChildren(): array
    {
        return $this->children;
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function getCategoryId(): string
    {
        return $this->categoryId;
    }

    public function isSystemRequired(): bool
    {
        return $this->isSystemRequired;
    }

    public function getParent(): ?ParentAttribute
    {
        return $this->parent;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getType(): string
    {
        return $this->type;
    }
}
