<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class Category implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        private string $title,
        private bool $multivalue,
        private string $className,
        private array $requiredAttributes,
        private array $parentChildAttributes
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function isMultivalue(): bool
    {
        return $this->multivalue;
    }

    public function getClassName(): string
    {
        return $this->className;
    }

    public function getParentChildAttributes(): array
    {
        return $this->parentChildAttributes;
    }

    public function getRequiredAttributes(): array
    {
        return $this->requiredAttributes;
    }

    public function getTitle(): string
    {
        return $this->title;
    }
}
