<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Model\Dto;

use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

class RequiredAttribute implements JsonSerializable
{
    use SerializableTrait;

    public function __construct(
        private string $id,
        private string $title,
        private string $type,
        private bool $isSystemRequired
    )
    {
    }

    public function getId(): string
    {
        return $this->id;
    }

    public function isSystemRequired(): bool
    {
        return $this->isSystemRequired;
    }

    public function getTitle(): string
    {
        return $this->title;
    }

    public function getType(): string
    {
        return $this->type;
    }
}
