<?php
/**
 * i-doit
 *
 * Admin Center 2.0
 *
 * @package   synetics_flows add-on
 * @copyright synetics
 * @license   https://www.i-doit.com/
 */

use idoit\Psr4AutoloaderClass;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

if (isys_module_manager::instance()->is_active('synetics_flows')) {
    require __DIR__ . '/vendor/autoload.php';
    Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\SyneticsFlows', __DIR__ . '/src/');
    Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Synetics_flows\Console\Command', __DIR__ . '/src/Console/Command');
    $container = isys_application::instance()->container;

    // Add 'Admin center' relevant routes.
    $container->get('routes')
        ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));
    if ($container->has('idoit.flows.signal')) {
        include_once isys_application::instance()->app_path . 'src/classes/modules/cmdb/init.php';
        $signalService = $container->get('idoit.flows.signal');
    }
}
