<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ActionType;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\AuthType\AuthType;
use idoit\Module\SyneticsFlows\Dto\KeyValueItem;
use idoit\Module\SyneticsFlows\Serialization\ArrayFormat;
use idoit\Module\SyneticsFlows\Validation\OneOf;
use idoit\Module\SyneticsFlows\Validation\Required;
use idoit\Module\SyneticsFlows\Validation\ValidationCallback;
use idoit\Module\SyneticsFlows\Validation\ValidationMessage;

class ApiCallAction extends ActionType
{
    public function __construct(
        #[Required]
        private ?string $url = null,
        #[OneOf(['GET', 'POST', 'PUT', 'PATCH', 'DELETE'])]
        private ?string $method = null,
        private ?AuthType $authType = null,
        #[ArrayFormat(KeyValueItem::class)]
        private array $headers = [],
        #[ArrayFormat(KeyValueItem::class)]
        private array $queryParams = [],
        private ?string $body = null,
    )
    {
    }

    #[ValidationCallback]
    public function checkUrl(array $path): array
    {
        $results = [];

        if (!filter_var($this->url, FILTER_VALIDATE_URL)) {
            $results[] = new ValidationMessage([...$path, 'url'], 'URL must be a valid URL.');
        }
        return $results;
    }

    public function getUrl(): ?string
    {
        return $this->url;
    }

    public function getMethod(): ?string
    {
        return $this->method;
    }

    public function getAuthType(): ?AuthType
    {
        return $this->authType;
    }

    /**
     * @return KeyValueItem[]
     */
    public function getHeaders(): array
    {
        return $this->headers;
    }

    /**
     * @return KeyValueItem[]
     */
    public function getQueryParams(): array
    {
        return $this->queryParams;
    }

    public function getBody(): ?string
    {
        return $this->body;
    }
}
