<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\ExecutionInfo;

use idoit\Module\SyneticsFlows\Serialization\Discriminator;
use idoit\Module\SyneticsFlows\Serialization\SerializableTrait;
use JsonSerializable;

#[Discriminator([
    'email' => SendEmailInfo::class,
    'create-object' => CreateObjectInfo::class,
    'update-data' => UpdateDataInfo::class,
    'api-call' => PerformApiCall::class,
])]
abstract class ExecutionInfo implements JsonSerializable
{
    use SerializableTrait;

    public abstract function __toString(): string;
}
