<?php declare(strict_types = 1);

namespace idoit\Module\SyneticsFlows\Automation\Action\PerformExecution;

use idoit\Module\SyneticsFlows\Automation\Action\ActionType\CmdbChange\CategoryChange;

class ValidateCategoryChanges extends AbstractCategoryChanges
{
    /**
     * @param int            $objectId
     * @param CategoryChange $change
     *
     * @return mixed
     */
    public function validateChange(int $objectId, CategoryChange $change): mixed
    {
        if (!($dao = $this->getDaoOfCategory($change))) {
            return false;
        }

        $data = $this->preparePropertiesData($change->getChanges());

        return $dao->validate($data);
    }
}
